/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class GetVarExpression
extends Expression {
    private final String variableName;

    public GetVarExpression(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        DataType output = context.getVariable(this.variableName);
        if (output == null) {
            throw new VerificationException(this, "Variable '" + this.variableName + "' not found");
        }
        return output;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(context.getVariable(this.variableName), outputType, null, context);
        return AnyDataType.instance;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        context.setCurrentValue(context.getVariable(this.variableName));
    }

    public String toString() {
        return "get_var " + this.variableName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GetVarExpression)) {
            return false;
        }
        GetVarExpression rhs = (GetVarExpression)((Object)obj);
        return this.variableName.equals(rhs.variableName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.variableName.hashCode();
    }
}

