/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.FieldValueConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.MapEntryFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.util.Map;
import java.util.Objects;

public final class ForEachExpression
extends CompositeExpression {
    private final Expression expression;

    public ForEachExpression(Expression expression) {
        this.expression = Objects.requireNonNull(expression);
    }

    @Override
    public boolean isMutating() {
        return this.expression.isMutating();
    }

    public Expression getInnerExpression() {
        return this.expression;
    }

    @Override
    public ForEachExpression convertChildren(ExpressionConverter converter) {
        Expression converted = converter.convert(this.expression);
        return converted != null ? new ForEachExpression(converted) : null;
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.expression.setStatementOutput(documentType, field);
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        if (inputType == null) {
            return null;
        }
        if (inputType instanceof ArrayDataType || inputType instanceof WeightedSetDataType) {
            return this.withInnerType(this.expression.setInputType(inputType.getNestedType(), context), inputType);
        }
        if (inputType instanceof StructDataType) {
            StructDataType struct = (StructDataType)inputType;
            return this.verifyStructFields(struct, context);
        }
        if (inputType instanceof MapDataType) {
            DataType outputType = this.expression.setInputType(inputType, context);
            if (outputType == null) {
                return this.getOutputType(context);
            }
            return DataType.getArray((DataType)outputType);
        }
        throw new VerificationException(this, "Expected Array, Struct, WeightedSet or Map input, got " + inputType.getName());
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        if (outputType == null) {
            return null;
        }
        super.setOutputType(outputType, context);
        if (outputType instanceof ArrayDataType || outputType instanceof WeightedSetDataType) {
            DataType innerInputType = this.expression.setOutputType(outputType.getNestedType(), context);
            if (innerInputType instanceof MapDataType) {
                MapDataType mapDataType = (MapDataType)innerInputType;
                return mapDataType;
            }
            return this.withInnerType(innerInputType, outputType);
        }
        if (outputType instanceof StructDataType) {
            StructDataType struct = (StructDataType)outputType;
            return this.verifyStructFields(struct, context);
        }
        if (outputType instanceof AnyDataType) {
            return outputType;
        }
        throw new VerificationException(this, "Expected Array, Struct, WeightedSet or Map input, got " + outputType.getName());
    }

    private DataType withInnerType(DataType innerType, DataType collectionType) {
        if (innerType == null) {
            return null;
        }
        if (collectionType instanceof WeightedSetDataType) {
            WeightedSetDataType wset = (WeightedSetDataType)collectionType;
            return DataType.getWeightedSet((DataType)innerType, (boolean)wset.createIfNonExistent(), (boolean)wset.removeIfZero());
        }
        return DataType.getArray((DataType)innerType);
    }

    private DataType verifyStructFields(StructDataType struct, VerificationContext context) {
        for (Field field : struct.getFields()) {
            DataType fieldType = field.getDataType();
            DataType fieldOutputType = this.expression.setInputType(fieldType, context);
            if (fieldOutputType != null && !fieldOutputType.isAssignableTo(fieldType)) {
                throw new VerificationException(this, "Struct field '" + field.getName() + "' has type " + fieldType.getName() + " but expression produces " + fieldOutputType.getName());
            }
            DataType fieldInputType = this.expression.setOutputType(fieldType, context);
            if (fieldOutputType != null && !fieldType.isAssignableTo(fieldInputType)) {
                throw new VerificationException(this, "Struct field '" + field.getName() + "' has type " + fieldType.getName() + " but expression requires " + fieldInputType.getName());
            }
            if (fieldOutputType != null || fieldInputType != null) continue;
            return null;
        }
        return struct;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        if (input instanceof Array || input instanceof WeightedSet) {
            FieldValue next = new ExecutionConverter(context, this.expression).convert(input);
            if (next == null) {
                next = this.getOutputType().createFieldValue();
            }
            context.setCurrentValue(next);
        } else if (input instanceof Struct || input instanceof Map) {
            context.setCurrentValue(new ExecutionConverter(context, this.expression).convert(input));
        } else {
            throw new IllegalArgumentException("Expected Array, Struct, WeightedSet or Map input, got " + input.getDataType().getName());
        }
    }

    public String toString() {
        return "for_each { " + String.valueOf((Object)this.expression) + " }";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ForEachExpression)) {
            return false;
        }
        ForEachExpression rhs = (ForEachExpression)((Object)obj);
        return ((Object)((Object)this.expression)).equals((Object)rhs.expression);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.expression)).hashCode();
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        ForEachExpression.select((Selectable)this.expression, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    private static final class ExecutionConverter
    extends FieldValueConverter {
        final ExecutionContext context;
        final Expression expression;
        int depth = 0;

        ExecutionConverter(ExecutionContext context, Expression expression) {
            this.context = context;
            this.expression = expression;
        }

        @Override
        protected boolean shouldConvert(FieldValue value) {
            return ++this.depth > 1;
        }

        @Override
        protected FieldValue convertMap(MapFieldValue<FieldValue, FieldValue> map) {
            Array values = new Array((DataType)new ArrayDataType(this.expression.getOutputType()), map.size());
            for (Map.Entry entry : map.entrySet()) {
                values.add(this.doConvert(new MapEntryFieldValue((FieldValue)entry.getKey(), (FieldValue)entry.getValue())));
            }
            return values;
        }

        @Override
        protected FieldValue doConvert(FieldValue value) {
            this.context.setCurrentValue(value).execute(this.expression);
            return this.context.getCurrentValue();
        }
    }
}

