/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.TextGenerator;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.AdapterFactory;
import com.yahoo.vespa.indexinglanguage.DocumentAdapter;
import com.yahoo.vespa.indexinglanguage.DocumentTypeAdapter;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.SimpleAdapterFactory;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValueAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.vespa.objects.Selectable;
import java.util.Map;

public abstract class Expression
extends Selectable {
    private DataType inputType;
    private DataType outputType;

    public boolean requiresInput() {
        return true;
    }

    public boolean isMutating() {
        return true;
    }

    public Expression convertChildren(ExpressionConverter converter) {
        return this;
    }

    public void setStatementOutput(DocumentType documentType, Field field) {
    }

    public DataType getInputType(VerificationContext context) {
        return this.inputType;
    }

    protected final DataType setInputType(DataType inputType, DataType requiredType, VerificationContext context) {
        if (requiredType != null && inputType == null) {
            throw new VerificationException(this, "Expected " + requiredType.getName() + " input, but no input is provided");
        }
        if (requiredType != null && !inputType.isAssignableTo(requiredType)) {
            throw new VerificationException(this, "Expected " + requiredType.getName() + " input, got " + inputType.getName());
        }
        return this.assignInputType(inputType);
    }

    public DataType setInputType(DataType inputType, VerificationContext context) {
        return this.assignInputType(inputType);
    }

    DataType assignInputType(DataType inputType) {
        this.inputType = this.leastGeneralNonNullOf(this.inputType, inputType);
        return this.inputType;
    }

    public DataType getOutputType(VerificationContext context) {
        return this.outputType;
    }

    public DataType getOutputType() {
        return this.outputType;
    }

    public DataType requireOutputType() {
        if (this.outputType == null) {
            throw new IllegalStateException("The output type of " + String.valueOf((Object)this) + " is unresolved");
        }
        return this.outputType;
    }

    protected final DataType setOutputType(DataType actualOutput, DataType requiredOutput, DataType requiredType, VerificationContext context) {
        if (actualOutput != null && requiredOutput != null && !actualOutput.isAssignableTo(requiredOutput)) {
            throw new VerificationException(this, "This produces type " + actualOutput.getName() + " but " + requiredOutput.getName() + " is required");
        }
        if (requiredType != null && requiredOutput != null && !requiredOutput.isAssignableTo(requiredType)) {
            throw new VerificationException(this, "This is required to produce type " + requiredOutput.getName() + " but is produces " + requiredType.getName());
        }
        return this.assignOutputType(actualOutput != null ? actualOutput : requiredOutput);
    }

    public DataType setOutputType(DataType outputType, VerificationContext context) {
        return this.assignOutputType(outputType);
    }

    DataType assignOutputType(DataType outputType) {
        this.outputType = this.leastGeneralNonNullOf(this.outputType, outputType);
        return this.outputType;
    }

    public final void verify(DocumentType type) {
        this.verify(new DocumentTypeAdapter(type));
    }

    public final void verify(Document doc) {
        this.verify((AdapterFactory)new SimpleAdapterFactory(), doc);
    }

    public final void verify(AdapterFactory factory, Document doc) {
        this.verify(factory.newDocumentAdapter(doc));
    }

    public final void verify(DocumentAdapter adapter) {
        this.verify((FieldTypeAdapter)adapter);
        adapter.getFullOutput();
    }

    public final void verify(DocumentUpdate upd) {
        this.verify((AdapterFactory)new SimpleAdapterFactory(), upd);
    }

    public final void verify(AdapterFactory factory, DocumentUpdate upd) {
        for (UpdateAdapter adapter : factory.newUpdateAdapterList(upd)) {
            this.verify(adapter);
        }
    }

    public final void verify(UpdateAdapter adapter) {
        this.verify((FieldTypeAdapter)adapter);
    }

    public final void verify(FieldTypeAdapter adapter) {
        this.verify(new VerificationContext(adapter));
    }

    public final void verify(VerificationContext context) {
        this.doVerify(context);
    }

    protected void doVerify(VerificationContext context) {
    }

    public final FieldValue execute(FieldValue val) {
        return this.execute(new ExecutionContext().setCurrentValue(val));
    }

    public final Document execute(AdapterFactory factory, Document doc) {
        return this.execute(factory.newDocumentAdapter(doc));
    }

    public final Document execute(DocumentAdapter adapter) {
        this.execute((FieldValueAdapter)adapter);
        return adapter.getFullOutput();
    }

    public static DocumentUpdate execute(Expression expression, AdapterFactory factory, DocumentUpdate update) {
        DocumentUpdate result = null;
        for (UpdateAdapter adapter : factory.newUpdateAdapterList(update)) {
            DocumentUpdate output = adapter.getExpression(expression).execute(adapter);
            if (output == null) continue;
            if (result != null) {
                result.addAll(output);
                continue;
            }
            result = output;
        }
        if (result != null) {
            result.setCreateIfNonExistent(update.getCreateIfNonExistent());
        }
        return result;
    }

    public final DocumentUpdate execute(UpdateAdapter adapter) {
        this.execute((FieldValueAdapter)adapter);
        return adapter.getOutput();
    }

    public final FieldValue execute(FieldValueAdapter adapter) {
        return this.execute(new ExecutionContext(adapter));
    }

    public final FieldValue execute(ExecutionContext context) {
        FieldValue input;
        if (this.requiresInput() && (input = context.getCurrentValue()) == null) {
            return null;
        }
        this.doExecute(context);
        return context.getCurrentValue();
    }

    protected abstract void doExecute(ExecutionContext var1);

    public static Expression fromString(String expression) throws ParseException {
        return Expression.fromString(expression, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap());
    }

    public static Expression fromString(String expression, Linguistics linguistics, Map<String, Embedder> embedders) throws ParseException {
        return Expression.newInstance(new ScriptParserContext(linguistics, embedders, Map.of()).setInputStream(new IndexingInput(expression)));
    }

    public static Expression fromString(String expression, Linguistics linguistics, Map<String, Embedder> embedders, Map<String, TextGenerator> generators) throws ParseException {
        return Expression.newInstance(new ScriptParserContext(linguistics, embedders, generators).setInputStream(new IndexingInput(expression)));
    }

    public static Expression newInstance(ScriptParserContext context) throws ParseException {
        return ScriptParser.parseExpression(context);
    }

    public static Document execute(Expression expression, Document doc) {
        expression.verify(doc);
        return expression.execute(new SimpleAdapterFactory(), doc);
    }

    public static DocumentUpdate execute(Expression expression, DocumentUpdate update) {
        return Expression.execute(expression, new SimpleAdapterFactory(), update);
    }

    public final FieldValue execute() {
        return this.execute(new ExecutionContext());
    }

    protected DataType mostGeneralOf(DataType left, DataType right) {
        if (left == null || right == null) {
            return null;
        }
        if (left.isAssignableTo(right)) {
            return right;
        }
        if (right.isAssignableTo(left)) {
            return left;
        }
        throw new VerificationException(this, left.getName() + " is incompatible with " + right.getName());
    }

    protected DataType leastGeneralOf(DataType left, DataType right) {
        if (left == null || right == null) {
            return null;
        }
        if (left.isAssignableTo(right)) {
            return left;
        }
        if (right.isAssignableTo(left)) {
            return right;
        }
        throw new VerificationException(this, left.getName() + " is incompatible with " + right.getName());
    }

    protected DataType mostGeneralNonNullOf(DataType left, DataType right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left.isAssignableTo(right)) {
            return right;
        }
        if (right.isAssignableTo(left)) {
            return left;
        }
        throw new VerificationException(this, left.getName() + " is incompatible with " + right.getName());
    }

    protected DataType leastGeneralNonNullOf(DataType left, DataType right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        if (left.isAssignableTo(right)) {
            return left;
        }
        if (right.isAssignableTo(left)) {
            return right;
        }
        throw new VerificationException(this, left.getName() + " is incompatible with " + right.getName());
    }
}

