/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.language.process.TokenType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import java.util.OptionalInt;

public final class ExactExpression
extends Expression {
    private final int maxTokenLength;

    private ExactExpression(OptionalInt maxTokenLength) {
        this.maxTokenLength = maxTokenLength.isPresent() ? maxTokenLength.getAsInt() : AnnotatorConfig.getDefaultMaxTokenLength();
    }

    public ExactExpression() {
        this(OptionalInt.empty());
    }

    public ExactExpression(int maxTokenLength) {
        this(OptionalInt.of(maxTokenLength));
    }

    @Override
    public boolean isMutating() {
        return false;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        return super.setInputType(inputType, (DataType)DataType.STRING, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        return super.setOutputType((DataType)DataType.STRING, outputType, null, context);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        SpanList root;
        StringFieldValue input = (StringFieldValue)context.getCurrentValue();
        if (input.getString().isEmpty()) {
            return;
        }
        StringFieldValue output = input.clone();
        context.setCurrentValue((FieldValue)output);
        String prev = output.getString();
        String next = LinguisticsCase.toLowerCase((String)prev);
        SpanTree tree = output.getSpanTree("linguistics");
        if (next.length() > this.maxTokenLength) {
            if (tree != null) {
                output.removeSpanTree("linguistics");
            }
            return;
        }
        if (tree == null) {
            root = new SpanList();
            tree = new SpanTree("linguistics", (SpanNode)root);
            output.setSpanTree(tree);
        } else {
            root = (SpanList)tree.getRoot();
        }
        Span node = new Span(0, prev.length());
        tree.annotate((SpanNode)node, new Annotation(AnnotationTypes.TERM, (FieldValue)(next.equals(prev) ? null : new StringFieldValue(next))));
        tree.annotate((SpanNode)node, new Annotation(AnnotationTypes.TOKEN_TYPE, (FieldValue)new IntegerFieldValue(TokenType.ALPHABETIC.getValue())));
        root.add((SpanNode)node);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("exact");
        if (this.maxTokenLength != AnnotatorConfig.getDefaultMaxTokenLength()) {
            s.append(" max-token-length:").append(this.maxTokenLength);
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ExactExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

