/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class CatExpression
extends ExpressionList<Expression> {
    public CatExpression(Expression ... expressions) {
        this((Collection<? extends Expression>)List.of(expressions));
    }

    public CatExpression(Collection<? extends Expression> expressions) {
        super(expressions);
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    @Override
    public CatExpression convertChildren(ExpressionConverter converter) {
        return new CatExpression((Collection<? extends Expression>)this.convertChildList(converter));
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        ArrayList<DataType> outputTypes = new ArrayList<DataType>(this.expressions().size());
        for (Expression expression : this.expressions()) {
            outputTypes.add(expression.setInputType(inputType, context));
        }
        DataType outputType = CatExpression.resolveOutputType(outputTypes);
        if (outputType == null) {
            outputType = this.getOutputType(context);
        }
        super.setOutputType(outputType, context);
        return outputType;
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        if (outputType == null) {
            return null;
        }
        if (!DataType.STRING.isAssignableTo(outputType) && !(outputType instanceof CollectionDataType)) {
            throw new VerificationException(this, "Required to produce " + outputType.getName() + ", but this produces a string or collection");
        }
        super.setOutputType(outputType, context);
        for (Expression expression : this.expressions()) {
            expression.setOutputType(AnyDataType.instance, context);
        }
        return AnyDataType.instance;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        LinkedList<FieldValue> values = new LinkedList<FieldValue>();
        for (Expression expression : this) {
            values.add(context.setCurrentValue(input).execute(expression).getCurrentValue());
        }
        DataType type = this.getOutputType();
        if (type == null) {
            throw new RuntimeException("Output type is not resolved in " + String.valueOf(this));
        }
        context.setCurrentValue(type == DataType.STRING ? CatExpression.asString(values) : CatExpression.asCollection(type, values));
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(" . ");
        }
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof CatExpression;
    }

    private static DataType resolveOutputType(List<DataType> types) {
        DataType resolved = null;
        for (DataType type : types) {
            if (type == null) {
                return null;
            }
            if (!(type instanceof CollectionDataType)) {
                return DataType.STRING;
            }
            if (resolved == null) {
                resolved = type;
                continue;
            }
            if (resolved.isAssignableFrom(type)) continue;
            return DataType.STRING;
        }
        return resolved;
    }

    private static FieldValue asString(List<FieldValue> outputs) {
        StringBuilder ret = new StringBuilder();
        for (FieldValue val : outputs) {
            if (val == null) {
                return null;
            }
            ret.append(val);
        }
        return new StringFieldValue(ret.toString());
    }

    private static FieldValue asCollection(DataType type, List<FieldValue> values) {
        if (type instanceof ArrayDataType) {
            return CatExpression.asArray((ArrayDataType)type, values);
        }
        if (type instanceof WeightedSetDataType) {
            return CatExpression.asWset((WeightedSetDataType)type, values);
        }
        throw new UnsupportedOperationException(type.getName());
    }

    private static FieldValue asArray(ArrayDataType arrType, List<FieldValue> values) {
        Array out = arrType.createFieldValue();
        for (FieldValue val : values) {
            if (val == null) continue;
            out.addAll((Collection)((Array)val));
        }
        return out;
    }

    private static FieldValue asWset(WeightedSetDataType wsetType, List<FieldValue> values) {
        WeightedSet out = wsetType.createFieldValue();
        for (FieldValue val : values) {
            if (val == null) continue;
            out.putAll((Map)((WeightedSet)val));
        }
        return out;
    }
}

