/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.NumericDataType;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AnyNumericDataType;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;

public final class ArithmeticExpression
extends CompositeExpression {
    private final Expression left;
    private final Operator op;
    private final Expression right;

    public ArithmeticExpression(Expression left, Operator op, Expression right) {
        this.left = Objects.requireNonNull(left);
        this.op = Objects.requireNonNull(op);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    public boolean requiresInput() {
        return false;
    }

    public Expression getLeftHandSide() {
        return this.left;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getRightHandSide() {
        return this.right;
    }

    @Override
    public ArithmeticExpression convertChildren(ExpressionConverter converter) {
        return new ArithmeticExpression(converter.convert(this.left), this.op, converter.convert(this.right));
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        DataType leftOutput = this.left.setInputType(inputType, context);
        DataType rightOutput = this.right.setInputType(inputType, context);
        return this.resultingType(leftOutput, rightOutput);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        if (outputType == null) {
            return null;
        }
        super.setOutputType(outputType, context);
        DataType leftInput = this.left.setOutputType((DataType)AnyNumericDataType.instance, context);
        DataType rightInput = this.right.setOutputType((DataType)AnyNumericDataType.instance, context);
        if (leftInput == null) {
            return this.getInputType(context);
        }
        if (rightInput == null) {
            return this.getInputType(context);
        }
        if (leftInput.isAssignableTo(rightInput)) {
            return rightInput;
        }
        if (rightInput.isAssignableTo(leftInput)) {
            return leftInput;
        }
        throw new VerificationException(this, "The left argument requires " + leftInput.getName() + ", while the right argument requires " + rightInput.getName() + ": These are incompatible");
    }

    private DataType resultingType(DataType left, DataType right) {
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof NumericDataType)) {
            throw new VerificationException(this, "The first argument must be a number, but has type " + left.getName());
        }
        if (!(right instanceof NumericDataType)) {
            throw new VerificationException(this, "The second argument must be a number, but has type " + right.getName());
        }
        if (left == DataType.FLOAT || left == DataType.DOUBLE || right == DataType.FLOAT || right == DataType.DOUBLE) {
            if (left == DataType.DOUBLE || right == DataType.DOUBLE) {
                return DataType.DOUBLE;
            }
            return DataType.FLOAT;
        }
        if (left == DataType.LONG || right == DataType.LONG) {
            return DataType.LONG;
        }
        return DataType.INT;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        context.setCurrentValue(this.evaluate(context.setCurrentValue(input).execute(this.left).getCurrentValue(), context.setCurrentValue(input).execute(this.right).getCurrentValue()));
    }

    public String toString() {
        return String.valueOf((Object)this.left) + " " + String.valueOf((Object)this.op) + " " + String.valueOf((Object)this.right);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArithmeticExpression)) {
            return false;
        }
        ArithmeticExpression expression = (ArithmeticExpression)((Object)object);
        if (!((Object)((Object)this.left)).equals((Object)expression.left)) {
            return false;
        }
        if (!this.op.equals((Object)expression.op)) {
            return false;
        }
        return ((Object)((Object)this.right)).equals((Object)expression.right);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.left)).hashCode() + this.op.hashCode() + ((Object)((Object)this.right)).hashCode();
    }

    private FieldValue evaluate(FieldValue lhs, FieldValue rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (!(lhs instanceof NumericFieldValue) || !(rhs instanceof NumericFieldValue)) {
            throw new IllegalArgumentException("Unsupported operation: [" + lhs.getDataType().getName() + "] " + String.valueOf((Object)this.op) + " [" + rhs.getDataType().getName() + "]");
        }
        BigDecimal lhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)lhs);
        BigDecimal rhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)rhs);
        return switch (this.op) {
            default -> throw new IncompatibleClassChangeError();
            case Operator.ADD -> this.createFieldValue(lhs, rhs, lhsVal.add(rhsVal));
            case Operator.SUB -> this.createFieldValue(lhs, rhs, lhsVal.subtract(rhsVal));
            case Operator.MUL -> this.createFieldValue(lhs, rhs, lhsVal.multiply(rhsVal));
            case Operator.DIV -> this.createFieldValue(lhs, rhs, lhsVal.divide(rhsVal, MathContext.DECIMAL64));
            case Operator.MOD -> this.createFieldValue(lhs, rhs, lhsVal.remainder(rhsVal));
        };
    }

    private FieldValue createFieldValue(FieldValue lhs, FieldValue rhs, BigDecimal val) {
        if (lhs instanceof FloatFieldValue || lhs instanceof DoubleFieldValue || rhs instanceof FloatFieldValue || rhs instanceof DoubleFieldValue) {
            if (lhs instanceof DoubleFieldValue || rhs instanceof DoubleFieldValue) {
                return new DoubleFieldValue(val.doubleValue());
            }
            return new FloatFieldValue(val.floatValue());
        }
        if (lhs instanceof LongFieldValue || rhs instanceof LongFieldValue) {
            return new LongFieldValue(val.longValue());
        }
        return new IntegerFieldValue(val.intValue());
    }

    public static BigDecimal asBigDecimal(NumericFieldValue value) {
        if (value instanceof ByteFieldValue) {
            return BigDecimal.valueOf(((ByteFieldValue)value).getByte());
        }
        if (value instanceof DoubleFieldValue) {
            return BigDecimal.valueOf(((DoubleFieldValue)value).getDouble());
        }
        if (value instanceof FloatFieldValue) {
            return BigDecimal.valueOf(((FloatFieldValue)value).getFloat());
        }
        if (value instanceof IntegerFieldValue) {
            return BigDecimal.valueOf(((IntegerFieldValue)value).getInteger());
        }
        if (value instanceof LongFieldValue) {
            return BigDecimal.valueOf(((LongFieldValue)value).getLong());
        }
        throw new IllegalArgumentException("Unsupported numeric field value type '" + value.getClass().getName() + "'");
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        this.left.select(predicate, operation);
        this.right.select(predicate, operation);
    }

    public static enum Operator {
        ADD(1, "+"),
        SUB(1, "-"),
        MUL(0, "*"),
        DIV(0, "/"),
        MOD(0, "%");

        private final int precedence;
        private final String img;

        private Operator(int precedence, String img) {
            this.precedence = precedence;
            this.img = img;
        }

        public boolean precedes(Operator op) {
            return this.precedence <= op.precedence;
        }

        public String toString() {
            return this.img;
        }
    }
}

