/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.fieldpathupdate.FieldPathUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.vespa.indexinglanguage.AdapterFactory;
import com.yahoo.vespa.indexinglanguage.DocumentAdapter;
import com.yahoo.vespa.indexinglanguage.FieldPathUpdateHelper;
import com.yahoo.vespa.indexinglanguage.FieldUpdateAdapter;
import com.yahoo.vespa.indexinglanguage.FieldUpdateHelper;
import com.yahoo.vespa.indexinglanguage.IdentityFieldPathUpdateAdapter;
import com.yahoo.vespa.indexinglanguage.SimpleDocumentAdapter;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.ArrayList;
import java.util.List;

public class SimpleAdapterFactory
implements AdapterFactory {
    private final SelectExpression expressionSelector;

    public SimpleAdapterFactory() {
        this(new SelectExpression());
    }

    public SimpleAdapterFactory(SelectExpression expressionSelector) {
        this.expressionSelector = expressionSelector;
    }

    @Override
    public DocumentAdapter newDocumentAdapter(Document doc) {
        return SimpleAdapterFactory.newDocumentAdapter(doc, false);
    }

    public static DocumentAdapter newDocumentAdapter(Document doc, boolean isUpdate) {
        if (isUpdate) {
            return new SimpleDocumentAdapter(doc);
        }
        return new SimpleDocumentAdapter(doc, doc);
    }

    @Override
    public List<UpdateAdapter> newUpdateAdapterList(DocumentUpdate update) {
        ArrayList<UpdateAdapter> ret = new ArrayList<UpdateAdapter>();
        DocumentType docType = update.getDocumentType();
        DocumentId docId = update.getId();
        Document complete = new Document(docType, update.getId());
        for (FieldPathUpdate fieldUpd : update) {
            try {
                if (FieldPathUpdateHelper.isComplete(fieldUpd)) {
                    FieldPathUpdateHelper.applyUpdate(fieldUpd, complete);
                    continue;
                }
                ret.add(new IdentityFieldPathUpdateAdapter(fieldUpd, SimpleAdapterFactory.newDocumentAdapter(complete, true)));
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Exception during handling of update '" + String.valueOf(fieldUpd) + "' to field '" + String.valueOf(fieldUpd.getFieldPath()) + "'", e);
            }
        }
        for (FieldUpdate fieldUpdate : update.fieldUpdates()) {
            Field field = fieldUpdate.getField();
            for (ValueUpdate valueUpdate : fieldUpdate.getValueUpdates()) {
                try {
                    if (FieldUpdateHelper.isComplete(field, valueUpdate)) {
                        FieldUpdateHelper.applyUpdate(field, valueUpdate, complete);
                        continue;
                    }
                    Document partial = FieldUpdateHelper.newPartialDocument(docType, docId, field, valueUpdate);
                    ret.add(FieldUpdateAdapter.fromPartialUpdate(this.expressionSelector.selectExpression(docType, field.getName()), SimpleAdapterFactory.newDocumentAdapter(partial, true), valueUpdate));
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException("Exception during handling of update '" + String.valueOf(valueUpdate) + "' to field '" + String.valueOf(field) + "'", e);
                }
            }
        }
        ret.add(FieldUpdateAdapter.fromCompleteUpdate(SimpleAdapterFactory.newDocumentAdapter(complete, true)));
        return ret;
    }

    public static class SelectExpression {
        public Expression selectExpression(DocumentType documentType, String fieldName) {
            return null;
        }
    }
}

