/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;

public final class BusyWaitExpression
extends Expression {
    @Override
    public boolean isMutating() {
        return false;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue value = context.getCurrentValue();
        if (value instanceof NumericFieldValue) {
            NumericFieldValue num = (NumericFieldValue)value;
            double napSecs = num.getNumber().doubleValue();
            long doom = System.nanoTime() + (long)(1.0E9 * napSecs);
            while (doom > System.nanoTime()) {
                double pi = 3.0;
                for (int i = 0; i < 1000; ++i) {
                    pi += BusyWaitExpression.nihlakanta(i);
                }
                context.getCache().put("Busy wait computing pi and store it to avoid jit optiming it away", pi);
            }
        }
    }

    private static double nihlakanta(int i) {
        long a = 2L + (long)i * 4L;
        return (double)(24L * (a + 2L)) / (double)(a * (a + 1L) * (a + 2L) * (a + 3L));
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return "busy_wait";
    }

    public boolean equals(Object obj) {
        return obj instanceof BusyWaitExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

