/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.MapEntryFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class GetFieldExpression
extends Expression {
    private static final String keyName = "$key";
    private static final String valueName = "$value";
    private final String structFieldName;

    public GetFieldExpression(String structFieldName) {
        this.structFieldName = structFieldName;
    }

    public String getFieldName() {
        return this.structFieldName;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        if (inputType == null) {
            return null;
        }
        return this.getFieldType(inputType, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(outputType, context);
        return this.getInputType(context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.getFieldType(context.getCurrentType(), context));
    }

    private DataType getFieldType(DataType input, VerificationContext context) {
        if (input instanceof MapDataType) {
            MapDataType entryInput = (MapDataType)input;
            if (this.structFieldName.equals(keyName)) {
                return entryInput.getKeyType();
            }
            if (this.structFieldName.equals(valueName)) {
                return entryInput.getValueType();
            }
            DataType dataType = entryInput.getValueType();
            if (dataType instanceof StructuredDataType) {
                StructuredDataType structInput = (StructuredDataType)dataType;
                return this.getStructFieldType(structInput);
            }
        } else if (input instanceof StructuredDataType) {
            StructuredDataType structInput = (StructuredDataType)input;
            return this.getStructFieldType(structInput);
        }
        throw new VerificationException(this, "Expected a struct or map, but got " + (input == null ? "no value" : input.getName()));
    }

    private DataType getStructFieldType(StructuredDataType structInput) {
        Field field = structInput.getField(this.structFieldName);
        if (field == null) {
            throw new VerificationException(this, "Field '" + this.structFieldName + "' not found in struct type '" + structInput.getName() + "'");
        }
        return field.getDataType();
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        if (input instanceof StructuredFieldValue) {
            StructuredFieldValue struct = (StructuredFieldValue)input;
            this.executeStructField(struct, context);
        } else if (input instanceof MapEntryFieldValue) {
            MapEntryFieldValue entry = (MapEntryFieldValue)input;
            this.executeMapEntry(entry, context);
        } else {
            throw new IllegalArgumentException("In " + this + ": Expected structured input, got " + input.getDataType().getName());
        }
    }

    private void executeMapEntry(MapEntryFieldValue entry, ExecutionContext context) {
        if (this.structFieldName.equals(keyName)) {
            context.setCurrentValue(entry.getKey());
        } else if (this.structFieldName.equals(valueName)) {
            context.setCurrentValue(entry.getValue());
        } else {
            FieldValue fieldValue = entry.getValue();
            if (fieldValue instanceof StructuredFieldValue) {
                StructuredFieldValue struct = (StructuredFieldValue)fieldValue;
                this.executeStructField(struct, context);
            } else {
                throw new IllegalArgumentException("In " + this + ": Expected structured input, got " + entry.getValue().getDataType().getName());
            }
        }
    }

    private void executeStructField(StructuredFieldValue struct, ExecutionContext context) {
        Field field = struct.getField(this.structFieldName);
        if (field == null) {
            throw new IllegalArgumentException("In " + this + ": Field '" + this.structFieldName + "' not found in struct type '" + struct.getDataType().getName() + "'");
        }
        context.setCurrentValue(struct.getFieldValue(field));
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "get_field " + this.structFieldName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GetFieldExpression)) {
            return false;
        }
        GetFieldExpression rhs = (GetFieldExpression)((Object)obj);
        return this.structFieldName.equals(rhs.structFieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.structFieldName.hashCode();
    }
}

