/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.AdapterFactory;
import com.yahoo.vespa.indexinglanguage.DocumentAdapter;
import com.yahoo.vespa.indexinglanguage.DocumentTypeAdapter;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.SimpleAdapterFactory;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValueAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.vespa.objects.Selectable;
import java.util.Map;

public abstract class Expression
extends Selectable {
    private final DataType requiredInputType;
    private DataType inputType;
    private DataType outputType;

    protected Expression(DataType requiredInputType) {
        this.requiredInputType = requiredInputType;
    }

    public Expression convertChildren(ExpressionConverter converter) {
        return this;
    }

    public void setStatementOutput(DocumentType documentType, Field field) {
    }

    public final DataType requiredInputType() {
        return this.requiredInputType;
    }

    public DataType getInputType(VerificationContext context) {
        return this.inputType;
    }

    protected final DataType setInputType(DataType inputType, DataType requiredType, VerificationContext context) {
        if (!inputType.isAssignableTo(requiredType)) {
            throw new VerificationException(this, "This requires type " + requiredType.getName() + ", but gets " + inputType.getName());
        }
        return this.assignInputType(inputType);
    }

    public DataType setInputType(DataType inputType, VerificationContext context) {
        return this.assignInputType(inputType);
    }

    private DataType assignInputType(DataType inputType) {
        if (this.inputType == null) {
            this.inputType = inputType;
        }
        return this.inputType;
    }

    public DataType getOutputType(VerificationContext context) {
        return this.outputType;
    }

    public DataType getOutputType() {
        return this.outputType;
    }

    public DataType requireOutputType() {
        if (this.outputType == null) {
            throw new IllegalStateException("The output type of " + this + " is unresolved");
        }
        return this.outputType;
    }

    protected final DataType setOutputType(DataType actualOutput, DataType requiredOutput, DataType requiredType, VerificationContext context) {
        if (actualOutput != null && requiredOutput != null && !actualOutput.isAssignableTo(requiredOutput)) {
            throw new VerificationException(this, "This produces type " + actualOutput.getName() + " but " + requiredOutput.getName() + " is required");
        }
        if (requiredType != null && requiredOutput != null && !requiredOutput.isAssignableTo(requiredType)) {
            throw new VerificationException(this, "This is required to produce type " + requiredOutput.getName() + " but is produces " + requiredType.getName());
        }
        return this.assignOutputType(actualOutput != null ? actualOutput : requiredOutput);
    }

    public DataType setOutputType(DataType outputType, VerificationContext context) {
        return this.assignOutputType(outputType);
    }

    private DataType assignOutputType(DataType outputType) {
        if (this.outputType == null) {
            this.outputType = outputType;
        }
        return this.outputType;
    }

    public abstract DataType createdOutputType();

    protected void doVerify(VerificationContext context) {
    }

    public final DataType verify() {
        return this.verify(new VerificationContext());
    }

    public final void verify(DocumentType type) {
        this.verify(new DocumentTypeAdapter(type));
    }

    public final DataType verify(DataType val) {
        return this.verify(new VerificationContext().setCurrentType(val));
    }

    public final Document verify(Document doc) {
        return this.verify((AdapterFactory)new SimpleAdapterFactory(), doc);
    }

    public final Document verify(AdapterFactory factory, Document doc) {
        return this.verify(factory.newDocumentAdapter(doc));
    }

    public final Document verify(DocumentAdapter adapter) {
        this.verify((FieldTypeAdapter)adapter);
        return adapter.getFullOutput();
    }

    public final DocumentUpdate verify(DocumentUpdate upd) {
        return this.verify((AdapterFactory)new SimpleAdapterFactory(), upd);
    }

    public final DocumentUpdate verify(AdapterFactory factory, DocumentUpdate upd) {
        DocumentUpdate ret = null;
        for (UpdateAdapter adapter : factory.newUpdateAdapterList(upd)) {
            DocumentUpdate output = this.verify(adapter);
            if (output == null) continue;
            if (ret != null) {
                ret.addAll(output);
                continue;
            }
            ret = output;
        }
        return ret;
    }

    public final DocumentUpdate verify(UpdateAdapter adapter) {
        this.verify((FieldTypeAdapter)adapter);
        return adapter.getOutput();
    }

    public final DataType verify(FieldTypeAdapter adapter) {
        return this.verify(new VerificationContext(adapter));
    }

    public final DataType verify(VerificationContext context) {
        if (this.requiredInputType != null) {
            DataType input = context.getCurrentType();
            if (input == null) {
                throw new VerificationException(this, "Expected " + this.requiredInputType.getName() + " input, but no input is specified");
            }
            if (input.getPrimitiveType() == UnresolvedDataType.INSTANCE) {
                throw new VerificationException(this, "Failed to resolve input type");
            }
            if (!this.requiredInputType.isAssignableFrom(input)) {
                throw new VerificationException(this, "Expected " + this.requiredInputType.getName() + " input, got " + input.getName());
            }
        }
        this.doVerify(context);
        DataType outputType = this.createdOutputType();
        if (outputType != null) {
            DataType output = context.getCurrentType();
            if (output == null) {
                throw new VerificationException(this, "Expected " + outputType.getName() + " output, but no output is specified");
            }
            if (output.getPrimitiveType() == UnresolvedDataType.INSTANCE) {
                throw new VerificationException(this, "Failed to resolve output type");
            }
            if (!outputType.isAssignableFrom(output)) {
                throw new VerificationException(this, "Expected " + outputType.getName() + " output, got " + output.getName());
            }
        }
        return context.getCurrentType();
    }

    public final FieldValue execute(FieldValue val) {
        return this.execute(new ExecutionContext().setCurrentValue(val));
    }

    public final Document execute(AdapterFactory factory, Document doc) {
        return this.execute(factory.newDocumentAdapter(doc));
    }

    public final Document execute(DocumentAdapter adapter) {
        this.execute((FieldValueAdapter)adapter);
        return adapter.getFullOutput();
    }

    public static DocumentUpdate execute(Expression expression, AdapterFactory factory, DocumentUpdate update) {
        DocumentUpdate result = null;
        for (UpdateAdapter adapter : factory.newUpdateAdapterList(update)) {
            DocumentUpdate output = adapter.getExpression(expression).execute(adapter);
            if (output == null) continue;
            if (result != null) {
                result.addAll(output);
                continue;
            }
            result = output;
        }
        if (result != null) {
            result.setCreateIfNonExistent(update.getCreateIfNonExistent());
        }
        return result;
    }

    public final DocumentUpdate execute(UpdateAdapter adapter) {
        this.execute((FieldValueAdapter)adapter);
        return adapter.getOutput();
    }

    public final FieldValue execute(FieldValueAdapter adapter) {
        return this.execute(new ExecutionContext(adapter));
    }

    public final FieldValue execute(ExecutionContext context) {
        FieldValue output;
        DataType inputType = this.requiredInputType();
        if (inputType != null) {
            FieldValue input = context.getCurrentValue();
            if (input == null) {
                return null;
            }
            if (!inputType.isValueCompatible(input)) {
                throw new IllegalArgumentException("Expression '" + this + "' expected " + inputType.getName() + " input, got " + input.getDataType().getName());
            }
        }
        this.doExecute(context);
        DataType outputType = this.createdOutputType();
        if (outputType != null && (output = context.getCurrentValue()) != null && !outputType.isValueCompatible(output)) {
            throw new IllegalStateException("Expression '" + this + "' expected " + outputType.getName() + " output, got " + output.getDataType().getName());
        }
        return context.getCurrentValue();
    }

    protected abstract void doExecute(ExecutionContext var1);

    public static Expression fromString(String expression) throws ParseException {
        return Expression.fromString(expression, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap());
    }

    public static Expression fromString(String expression, Linguistics linguistics, Map<String, Embedder> embedders) throws ParseException {
        return Expression.newInstance(new ScriptParserContext(linguistics, embedders).setInputStream(new IndexingInput(expression)));
    }

    public static Expression newInstance(ScriptParserContext context) throws ParseException {
        return ScriptParser.parseExpression(context);
    }

    protected static boolean equals(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        if (rhs == null) {
            return false;
        }
        return lhs.equals(rhs);
    }

    public static Document execute(Expression expression, Document doc) {
        return expression.execute(new SimpleAdapterFactory(), doc);
    }

    public static DocumentUpdate execute(Expression expression, DocumentUpdate update) {
        return Expression.execute(expression, new SimpleAdapterFactory(), update);
    }

    public final FieldValue execute() {
        return this.execute(new ExecutionContext());
    }

    protected DataType mostGeneralOf(DataType left, DataType right) {
        if (left == null || right == null) {
            return null;
        }
        return left.isAssignableTo(right) ? right : left;
    }

    protected DataType leastGeneralOf(DataType left, DataType right) {
        if (left == null || right == null) {
            return null;
        }
        return left.isAssignableTo(right) ? left : right;
    }
}

