/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationTypes;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class FlattenExpression
extends Expression {
    public FlattenExpression() {
        super((DataType)DataType.STRING);
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        return super.setInputType(inputType, (DataType)DataType.STRING, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        return super.setOutputType((DataType)DataType.STRING, outputType, null, context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.createdOutputType());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        StringFieldValue input = (StringFieldValue)context.getCurrentValue();
        SpanTree tree = input.getSpanTree("linguistics");
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (Annotation anno : tree) {
            SpanNode span = anno.getSpanNode();
            if (span == null || anno.getType() != AnnotationTypes.TERM) continue;
            FieldValue val = anno.getFieldValue();
            String s = val instanceof StringFieldValue ? ((StringFieldValue)val).getString() : input.getString().substring(span.getFrom(), span.getTo());
            Integer pos = span.getTo();
            List entry = map.computeIfAbsent(pos, k -> new LinkedList());
            entry.add(s);
        }
        String inputVal = String.valueOf(input);
        StringBuilder output = new StringBuilder();
        int len = inputVal.length();
        for (int i = 0; i <= len; ++i) {
            List entry = (List)map.get(i);
            if (entry != null) {
                Collections.sort(entry);
                output.append(entry);
            }
            if (i >= len) continue;
            output.append(inputVal.charAt(i));
        }
        context.setCurrentValue((FieldValue)new StringFieldValue(output.toString()));
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "flatten";
    }

    public boolean equals(Object obj) {
        return obj instanceof FlattenExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

