/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.regex.Pattern;

public final class SplitExpression
extends Expression {
    private final Pattern splitPattern;

    public SplitExpression(String splitString) {
        super((DataType)DataType.STRING);
        this.splitPattern = Pattern.compile(splitString);
    }

    public Pattern getSplitPattern() {
        return this.splitPattern;
    }

    @Override
    public DataType setInputType(DataType input, VerificationContext context) {
        super.setInputType(input, context);
        return new ArrayDataType((DataType)DataType.STRING);
    }

    @Override
    public DataType setOutputType(DataType output, VerificationContext context) {
        super.setOutputType(output, context);
        return DataType.STRING;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.createdOutputType());
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        String input = String.valueOf(context.getCurrentValue());
        Array output = new Array((DataType)DataType.getArray((DataType)DataType.STRING));
        if (!input.isEmpty()) {
            String[] splits;
            for (String split : splits = this.splitPattern.split(input)) {
                output.add((FieldValue)new StringFieldValue(split));
            }
        }
        context.setCurrentValue((FieldValue)output);
    }

    @Override
    public DataType createdOutputType() {
        return DataType.getArray((DataType)DataType.STRING);
    }

    public String toString() {
        return "split \"" + StringUtilities.escape((String)this.splitPattern.toString(), (char)'\"') + "\"";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SplitExpression)) {
            return false;
        }
        SplitExpression rhs = (SplitExpression)((Object)obj);
        return this.splitPattern.toString().equals(rhs.splitPattern.toString());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.splitPattern.toString().hashCode();
    }
}

