/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.AnyDataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public final class GetFieldExpression
extends Expression {
    private final String structFieldName;

    public GetFieldExpression(String structFieldName) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.structFieldName = structFieldName;
    }

    public String getFieldName() {
        return this.structFieldName;
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        super.setInputType(inputType, context);
        return this.getStructFieldType(context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        super.setOutputType(this.getStructFieldType(context), outputType, context);
        return AnyDataType.instance;
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setCurrentType(this.getStructFieldType(context));
    }

    private DataType getStructFieldType(VerificationContext context) {
        DataType input = context.getCurrentType();
        if (!(input instanceof StructuredDataType)) {
            throw new VerificationException(this, "Expected structured input, got " + input.getName());
        }
        StructuredDataType structInput = (StructuredDataType)input;
        Field field = structInput.getField(this.structFieldName);
        if (field == null) {
            throw new VerificationException(this, "Field '" + this.structFieldName + "' not found in struct type '" + input.getName() + "'");
        }
        return field.getDataType();
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        if (!(input instanceof StructuredFieldValue)) {
            throw new IllegalArgumentException("Expected structured input, got " + input.getDataType().getName());
        }
        StructuredFieldValue struct = (StructuredFieldValue)input;
        Field field = struct.getField(this.structFieldName);
        if (field == null) {
            throw new IllegalArgumentException("Field '" + this.structFieldName + "' not found in struct type '" + struct.getDataType().getName() + "'");
        }
        context.setCurrentValue(struct.getFieldValue(field));
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "get_field " + this.structFieldName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GetFieldExpression)) {
            return false;
        }
        GetFieldExpression rhs = (GetFieldExpression)((Object)obj);
        return this.structFieldName.equals(rhs.structFieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + this.structFieldName.hashCode();
    }
}

