/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.StructDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.FieldValueConverter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.util.Objects;

public final class ForEachExpression
extends CompositeExpression {
    private final Expression expression;

    public ForEachExpression(Expression expression) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.expression = Objects.requireNonNull(expression);
    }

    public Expression getInnerExpression() {
        return this.expression;
    }

    @Override
    public ForEachExpression convertChildren(ExpressionConverter converter) {
        Expression converted = converter.convert(this.expression);
        return converted != null ? new ForEachExpression(converted) : null;
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.expression.setStatementOutput(documentType, field);
    }

    @Override
    public DataType setInputType(DataType inputType, VerificationContext context) {
        this.expression.setInputType(inputType.getNestedType(), context);
        return super.setInputType(inputType, context);
    }

    @Override
    public DataType setOutputType(DataType outputType, VerificationContext context) {
        this.expression.setOutputType(outputType.getNestedType(), context);
        return super.setOutputType(outputType, context);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType valueType = context.getCurrentType();
        if (valueType instanceof ArrayDataType || valueType instanceof WeightedSetDataType) {
            context.setCurrentType(((CollectionDataType)valueType).getNestedType());
            context.verify(this.expression);
            if (valueType instanceof ArrayDataType) {
                context.setCurrentType((DataType)DataType.getArray((DataType)context.getCurrentType()));
            } else {
                WeightedSetDataType wset = (WeightedSetDataType)valueType;
                context.setCurrentType((DataType)DataType.getWeightedSet((DataType)context.getCurrentType(), (boolean)wset.createIfNonExistent(), (boolean)wset.removeIfZero()));
            }
        } else if (valueType instanceof StructDataType) {
            for (Field field : ((StructDataType)valueType).getFields()) {
                DataType structValueType;
                DataType fieldType = field.getDataType();
                if (fieldType.isAssignableFrom(structValueType = context.setCurrentType(fieldType).verify(this.expression).getCurrentType())) continue;
                throw new VerificationException(this, "Expected " + fieldType.getName() + " output, got " + structValueType.getName());
            }
            context.setCurrentType(valueType);
        } else {
            throw new VerificationException(this, "Expected Array, Struct or WeightedSet input, got " + valueType.getName());
        }
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getCurrentValue();
        if (input instanceof Array || input instanceof WeightedSet) {
            FieldValue next = new MyConverter(context, this.expression).convert(input);
            if (next == null) {
                VerificationContext verificationContext = new VerificationContext(context.getFieldValue());
                context.fillVariableTypes(verificationContext);
                verificationContext.setCurrentType(input.getDataType()).verify(this);
                next = verificationContext.getCurrentType().createFieldValue();
            }
            context.setCurrentValue(next);
        } else if (input instanceof Struct) {
            context.setCurrentValue(new MyConverter(context, this.expression).convert(input));
        } else {
            throw new IllegalArgumentException("Expected Array, Struct or WeightedSet input, got " + input.getDataType().getName());
        }
    }

    @Override
    public DataType createdOutputType() {
        if (this.expression.createdOutputType() == null) {
            return null;
        }
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "for_each { " + this.expression + " }";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ForEachExpression)) {
            return false;
        }
        ForEachExpression rhs = (ForEachExpression)((Object)obj);
        return ((Object)((Object)this.expression)).equals((Object)rhs.expression);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.expression)).hashCode();
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        ForEachExpression.select((Selectable)this.expression, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    private static final class MyConverter
    extends FieldValueConverter {
        final ExecutionContext context;
        final Expression expression;
        int depth = 0;

        MyConverter(ExecutionContext context, Expression expression) {
            this.context = context;
            this.expression = expression;
        }

        @Override
        protected boolean shouldConvert(FieldValue value) {
            return ++this.depth > 1;
        }

        @Override
        protected FieldValue doConvert(FieldValue value) {
            this.context.setCurrentValue(value).execute(this.expression);
            return this.context.getCurrentValue();
        }
    }
}

