/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.NumericFieldValue;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.ArithmeticExpression;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.math.BigDecimal;

public final class IfThenExpression
extends CompositeExpression {
    private final Expression left;
    private final Comparator comparator;
    private final Expression right;
    private final Expression ifTrue;
    private final Expression ifFalse;

    public IfThenExpression(Expression lhs, Comparator cmp, Expression right, Expression ifTrue) {
        this(lhs, cmp, right, ifTrue, null);
    }

    public IfThenExpression(Expression lhs, Comparator cmp, Expression right, Expression ifTrue, Expression ifFalse) {
        super(IfThenExpression.resolveInputType(lhs, right, ifTrue, ifFalse));
        this.left = lhs;
        this.comparator = cmp;
        this.right = right;
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
    }

    @Override
    public IfThenExpression convertChildren(ExpressionConverter converter) {
        return new IfThenExpression(converter.branch().convert(this.left), this.comparator, converter.branch().convert(this.right), converter.branch().convert(this.ifTrue), converter.branch().convert(this.ifFalse));
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.left.setStatementOutput(documentType, field);
        this.right.setStatementOutput(documentType, field);
        this.ifTrue.setStatementOutput(documentType, field);
        this.ifFalse.setStatementOutput(documentType, field);
    }

    public Expression getLeftHandSide() {
        return this.left;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Expression getRightHandSide() {
        return this.right;
    }

    public Expression getIfTrueExpression() {
        return this.ifTrue;
    }

    public Expression getIfFalseExpression() {
        return this.ifFalse;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getValue();
        FieldValue leftValue = context.setValue(input).execute(this.left).getValue();
        if (leftValue == null) {
            context.setValue(null);
            return;
        }
        FieldValue rightValue = context.setValue(input).execute(this.right).getValue();
        if (rightValue == null) {
            context.setValue(null);
            return;
        }
        context.setValue(input);
        if (IfThenExpression.isTrue(leftValue, this.comparator, rightValue)) {
            this.ifTrue.execute(context);
        } else if (this.ifFalse != null) {
            this.ifFalse.execute(context);
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValueType();
        context.setValueType(input).execute(this.left);
        context.setValueType(input).execute(this.right);
        VerificationContext trueValue = context.setValueType(input).execute(this.ifTrue);
        VerificationContext falseValue = context.setValueType(input).execute(this.ifFalse);
        DataType valueType = trueValue.getValueType().isAssignableFrom(falseValue.getValueType()) ? trueValue.getValueType() : falseValue.getValueType();
        context.setValueType(valueType);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        IfThenExpression.select((Selectable)this.left, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.right, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.ifTrue, (ObjectPredicate)predicate, (ObjectOperation)operation);
        IfThenExpression.select((Selectable)this.ifFalse, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    private static DataType resolveInputType(Expression lhs, Expression rhs, Expression ifTrue, Expression ifFalse) {
        DataType input = null;
        input = IfThenExpression.resolveRequiredInputType(input, lhs.requiredInputType());
        input = IfThenExpression.resolveRequiredInputType(input, rhs.requiredInputType());
        input = IfThenExpression.resolveRequiredInputType(input, ifTrue.requiredInputType());
        if (ifFalse != null) {
            input = IfThenExpression.resolveRequiredInputType(input, ifFalse.requiredInputType());
        }
        return input;
    }

    @Override
    public DataType createdOutputType() {
        DataType ifFalseType;
        DataType ifTrueType = this.ifTrue.createdOutputType();
        DataType dataType = ifFalseType = this.ifFalse == null ? null : this.ifFalse.createdOutputType();
        if (ifTrueType == null || ifFalseType == null) {
            return null;
        }
        if (ifTrueType.isAssignableFrom(ifFalseType)) {
            return ifTrueType;
        }
        return ifFalseType;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("if (").append((Object)this.left).append(" ").append((Object)this.comparator).append(" ").append((Object)this.right).append(") ");
        ret.append(IfThenExpression.toScriptBlock(this.ifTrue));
        if (this.ifFalse != null) {
            ret.append(" else ").append(IfThenExpression.toScriptBlock(this.ifFalse));
        }
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IfThenExpression)) {
            return false;
        }
        IfThenExpression exp = (IfThenExpression)((Object)obj);
        if (!((Object)((Object)this.left)).equals((Object)exp.left)) {
            return false;
        }
        if (!this.comparator.equals((Object)exp.comparator)) {
            return false;
        }
        if (!((Object)((Object)this.right)).equals((Object)exp.right)) {
            return false;
        }
        if (!((Object)((Object)this.ifTrue)).equals((Object)exp.ifTrue)) {
            return false;
        }
        return IfThenExpression.equals((Object)this.ifFalse, (Object)exp.ifFalse);
    }

    public int hashCode() {
        int ret = ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.left)).hashCode() + this.comparator.hashCode() + ((Object)((Object)this.right)).hashCode() + ((Object)((Object)this.ifTrue)).hashCode();
        if (this.ifFalse != null) {
            ret += ((Object)((Object)this.ifFalse)).hashCode();
        }
        return ret;
    }

    private static DataType resolveRequiredInputType(DataType prev, DataType next) {
        if (next == null) {
            return prev;
        }
        if (prev == null) {
            return next;
        }
        if (!prev.equals((Object)next)) {
            throw new VerificationException(IfThenExpression.class, "Operands require conflicting input types, " + prev.getName() + " vs " + next.getName());
        }
        return prev;
    }

    private static boolean isTrue(FieldValue lhs, Comparator cmp, FieldValue rhs) {
        int res;
        if (lhs instanceof NumericFieldValue && rhs instanceof NumericFieldValue) {
            BigDecimal lhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)lhs);
            BigDecimal rhsVal = ArithmeticExpression.asBigDecimal((NumericFieldValue)rhs);
            res = lhsVal.compareTo(rhsVal);
        } else {
            res = lhs.compareTo(rhs);
        }
        return switch (cmp) {
            default -> throw new IncompatibleClassChangeError();
            case Comparator.EQ -> {
                if (res == 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.NE -> {
                if (res != 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.GT -> {
                if (res > 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.GE -> {
                if (res >= 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.LT -> {
                if (res < 0) {
                    yield true;
                }
                yield false;
            }
            case Comparator.LE -> res <= 0;
        };
    }

    public static enum Comparator {
        EQ("=="),
        NE("!="),
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">=");

        private final String img;

        private Comparator(String img) {
            this.img = img;
        }

        public String toString() {
            return this.img;
        }
    }
}

