/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.nio.charset.StandardCharsets;

public class HashExpression
extends Expression {
    private final HashFunction hasher = Hashing.sipHash24();
    private DataType targetType;

    public HashExpression() {
        super((DataType)DataType.STRING);
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        if (!this.canStoreHash(field.getDataType())) {
            throw new IllegalArgumentException("Cannot use the hash function on an indexing statement for " + field.getName() + ": The hash function can only be used when the target field is int or long or an array of int or long, not " + field.getDataType());
        }
        this.targetType = field.getDataType().getPrimitiveType();
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        StringFieldValue input = (StringFieldValue)context.getValue();
        if (this.targetType.equals((Object)DataType.INT)) {
            context.setValue((FieldValue)new IntegerFieldValue(this.hashToInt(input.getString())));
        } else if (this.targetType.equals((Object)DataType.LONG)) {
            context.setValue((FieldValue)new LongFieldValue(this.hashToLong(input.getString())));
        } else {
            throw new IllegalStateException();
        }
    }

    private int hashToInt(String value) {
        return this.hasher.hashString((CharSequence)value, StandardCharsets.UTF_8).asInt();
    }

    private long hashToLong(String value) {
        return this.hasher.hashString((CharSequence)value, StandardCharsets.UTF_8).asLong();
    }

    @Override
    protected void doVerify(VerificationContext context) {
        String outputField = context.getOutputField();
        if (outputField == null) {
            throw new VerificationException(this, "No output field in this statement: Don't know what value to hash to");
        }
        DataType outputFieldType = context.getInputType(this, outputField);
        if (!this.canStoreHash(outputFieldType)) {
            throw new VerificationException(this, "The type of the output field " + outputField + " is not int or long but " + outputFieldType);
        }
        this.targetType = outputFieldType.getPrimitiveType();
        context.setValueType(this.createdOutputType());
    }

    private boolean canStoreHash(DataType type) {
        if (type.equals((Object)DataType.INT)) {
            return true;
        }
        if (type.equals((Object)DataType.LONG)) {
            return true;
        }
        if (type instanceof ArrayDataType) {
            return this.canStoreHash(((ArrayDataType)type).getNestedType());
        }
        return false;
    }

    @Override
    public DataType createdOutputType() {
        return this.targetType;
    }

    public String toString() {
        return "hash";
    }

    public int hashCode() {
        return 987;
    }

    public boolean equals(Object o) {
        return o instanceof HashExpression;
    }
}

