/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.collections.LazyMap;
import com.yahoo.document.DataType;
import com.yahoo.document.FieldPath;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.detect.Detection;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.FieldTypeAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.FieldValueAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ExecutionContext
implements FieldTypeAdapter,
FieldValueAdapter {
    private final Map<String, FieldValue> variables = new HashMap<String, FieldValue>();
    private final FieldValueAdapter adapter;
    private FieldValue value;
    private Language language;
    private final Map<Object, Object> cache = LazyMap.newHashMap();

    public ExecutionContext() {
        this(null);
    }

    public ExecutionContext(FieldValueAdapter adapter) {
        this.adapter = adapter;
        this.language = Language.UNKNOWN;
    }

    public ExecutionContext execute(Expression expression) {
        if (expression != null) {
            expression.execute(this);
        }
        return this;
    }

    @Override
    public boolean isComplete() {
        return this.adapter != null && this.adapter.isComplete();
    }

    @Override
    public DataType getInputType(Expression exp, String fieldName) {
        return this.adapter.getInputType(exp, fieldName);
    }

    @Override
    public FieldValue getInputValue(String fieldName) {
        if (this.adapter == null) {
            throw new IllegalStateException("Can not get field '" + fieldName + "' because adapter is null");
        }
        return this.adapter.getInputValue(fieldName);
    }

    @Override
    public FieldValue getInputValue(FieldPath fieldPath) {
        if (this.adapter == null) {
            throw new IllegalStateException("Can not get field '" + fieldPath + "' because adapter is null");
        }
        return this.adapter.getInputValue(fieldPath);
    }

    @Override
    public void tryOutputType(Expression exp, String fieldName, DataType valueType) {
        this.adapter.tryOutputType(exp, fieldName, valueType);
    }

    @Override
    public ExecutionContext setOutputValue(Expression exp, String fieldName, FieldValue fieldValue) {
        if (this.adapter == null) {
            throw new IllegalStateException("Can not set field '" + fieldName + "' because adapter is null");
        }
        this.adapter.setOutputValue(exp, fieldName, fieldValue);
        return this;
    }

    public FieldValueAdapter getAdapter() {
        return this.adapter;
    }

    public FieldValue getVariable(String name) {
        return this.variables.get(name);
    }

    public ExecutionContext setVariable(String name, FieldValue value) {
        this.variables.put(name, value);
        return this;
    }

    public Language getLanguage() {
        return this.language;
    }

    public ExecutionContext setLanguage(Language language) {
        this.language = Objects.requireNonNull(language);
        return this;
    }

    public Language resolveLanguage(Linguistics linguistics) {
        if (this.language != Language.UNKNOWN) {
            return this.language;
        }
        if (linguistics == null) {
            return Language.ENGLISH;
        }
        Detection detection = linguistics.getDetector().detect(String.valueOf(this.value), null);
        if (detection == null) {
            return Language.ENGLISH;
        }
        Language detected = detection.getLanguage();
        if (detected == Language.UNKNOWN) {
            return Language.ENGLISH;
        }
        return detected;
    }

    public FieldValue getValue() {
        return this.value;
    }

    public ExecutionContext setValue(FieldValue value) {
        this.value = value;
        return this;
    }

    public void putCachedValue(String key, Object value) {
        this.cache.put(key, value);
    }

    public Object getCachedValue(Object key) {
        return this.cache.get(key);
    }

    public Map<Object, Object> getCache() {
        return this.cache;
    }

    public ExecutionContext clear() {
        this.variables.clear();
        this.value = null;
        return this;
    }

    void fillVariableTypes(VerificationContext vctx) {
        for (Map.Entry<String, FieldValue> entry : this.variables.entrySet()) {
            vctx.setVariable(entry.getKey(), entry.getValue().getDataType());
        }
    }
}

