/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage;

import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.StructuredDataType;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import com.yahoo.document.update.TensorAddUpdate;
import com.yahoo.document.update.TensorModifyUpdate;
import com.yahoo.document.update.TensorRemoveUpdate;
import com.yahoo.document.update.ValueUpdate;

public abstract class FieldUpdateHelper {
    public static boolean isComplete(Field field, ValueUpdate update) {
        if (update instanceof AssignValueUpdate) {
            return true;
        }
        if (!(update instanceof MapValueUpdate)) {
            return false;
        }
        DataType fieldType = field.getDataType();
        if (!(fieldType instanceof StructuredDataType)) {
            return false;
        }
        field = ((StructuredDataType)fieldType).getField(String.valueOf(update.getValue()));
        if (field == null) {
            return false;
        }
        return FieldUpdateHelper.isComplete(field, ((MapValueUpdate)update).getUpdate());
    }

    public static void applyUpdate(Field field, ValueUpdate update, Document doc) {
        doc.setFieldValue(field, FieldUpdateHelper.applyUpdate(update, field.getDataType().createFieldValue()));
    }

    public static Document newPartialDocument(DocumentType docType, DocumentId docId, Field field, ValueUpdate update) {
        Document doc = new Document(docType, docId);
        FieldUpdateHelper.applyUpdate(field, update, doc);
        return doc;
    }

    private static FieldValue applyUpdate(ValueUpdate update, FieldValue value) {
        if (update instanceof ClearValueUpdate) {
            return value;
        }
        if (update instanceof AssignValueUpdate) {
            value.assign((Object)update.getValue());
            return value;
        }
        if (update instanceof AddValueUpdate) {
            if (value instanceof Array) {
                ((Array)value).add(update.getValue());
            } else if (value instanceof WeightedSet) {
                ((WeightedSet)value).put(update.getValue(), Integer.valueOf(((AddValueUpdate)update).getWeight()));
            }
            return value;
        }
        if (update instanceof ArithmeticValueUpdate) {
            if (((ArithmeticValueUpdate)update).getOperator() == ArithmeticValueUpdate.Operator.DIV && ((ArithmeticValueUpdate)update).getOperand().doubleValue() == 0.0) {
                throw new IllegalArgumentException("Division by zero");
            }
            value.assign((Object)update.getValue());
            return value;
        }
        if (update instanceof RemoveValueUpdate) {
            if (value instanceof Array) {
                ((Array)value).add(update.getValue());
            } else if (value instanceof WeightedSet) {
                ((WeightedSet)value).put(update.getValue(), Integer.valueOf(1));
            }
            return value;
        }
        if (update instanceof MapValueUpdate) {
            if (value instanceof Array) {
                ValueUpdate nestedUpdate = ((MapValueUpdate)update).getUpdate();
                if (nestedUpdate instanceof AssignValueUpdate) {
                    ((Array)value).add(nestedUpdate.getValue());
                    return value;
                }
                return FieldUpdateHelper.applyUpdate(nestedUpdate, value);
            }
            if (value instanceof MapFieldValue) {
                throw new UnsupportedOperationException("Can not map into a " + value.getClass().getName());
            }
            if (value instanceof StructuredFieldValue) {
                Field field = ((StructuredFieldValue)value).getField(String.valueOf(update.getValue()));
                if (field == null) {
                    throw new IllegalArgumentException("Field '" + update.getValue() + "' not found");
                }
                ((StructuredFieldValue)value).setFieldValue(field, FieldUpdateHelper.applyUpdate(((MapValueUpdate)update).getUpdate(), field.getDataType().createFieldValue()));
                return value;
            }
            if (value instanceof WeightedSet) {
                FieldValue weight = FieldUpdateHelper.applyUpdate(((MapValueUpdate)update).getUpdate(), (FieldValue)new IntegerFieldValue());
                if (!(weight instanceof IntegerFieldValue)) {
                    throw new IllegalArgumentException("Expected integer, got " + weight.getClass().getName());
                }
                ((WeightedSet)value).put(update.getValue(), Integer.valueOf(((IntegerFieldValue)weight).getInteger()));
                return value;
            }
            throw new IllegalArgumentException("Expected multi-value data type, got " + value.getDataType().getName());
        }
        if (update instanceof TensorModifyUpdate) {
            return value;
        }
        if (update instanceof TensorAddUpdate) {
            return value;
        }
        if (update instanceof TensorRemoveUpdate) {
            return value;
        }
        throw new UnsupportedOperationException("Value update type " + update.getClass().getName() + " not supported");
    }
}

