/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.parser;

import com.yahoo.collections.Pair;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.ArithmeticExpression;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Base64DecodeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Base64EncodeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.CatExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ChoiceExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ClearStateExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ConstantExpression;
import com.yahoo.vespa.indexinglanguage.expressions.EchoExpression;
import com.yahoo.vespa.indexinglanguage.expressions.EmbedExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExactExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionValueExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.FlattenExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.GetFieldExpression;
import com.yahoo.vespa.indexinglanguage.expressions.GetVarExpression;
import com.yahoo.vespa.indexinglanguage.expressions.GuardExpression;
import com.yahoo.vespa.indexinglanguage.expressions.HashExpression;
import com.yahoo.vespa.indexinglanguage.expressions.HexDecodeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.HexEncodeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.HostNameExpression;
import com.yahoo.vespa.indexinglanguage.expressions.IfThenExpression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.JoinExpression;
import com.yahoo.vespa.indexinglanguage.expressions.LiteralBoolExpression;
import com.yahoo.vespa.indexinglanguage.expressions.LowerCaseExpression;
import com.yahoo.vespa.indexinglanguage.expressions.MathResolver;
import com.yahoo.vespa.indexinglanguage.expressions.NGramExpression;
import com.yahoo.vespa.indexinglanguage.expressions.NormalizeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.NowExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OptimizePredicateExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ParenthesisExpression;
import com.yahoo.vespa.indexinglanguage.expressions.PassthroughExpression;
import com.yahoo.vespa.indexinglanguage.expressions.RandomExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SelectInputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetLanguageExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetVarExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SplitExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SubstringExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SwitchExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ThisExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToArrayExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToBoolExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToByteExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToDoubleExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToEpochSecondExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToFloatExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToIntegerExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToLongExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToPositionExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToStringExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ToWsetExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TokenizeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.TrimExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ZCurveExpression;
import com.yahoo.vespa.indexinglanguage.linguistics.AnnotatorConfig;
import com.yahoo.vespa.indexinglanguage.parser.CharStream;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.IndexingParserConstants;
import com.yahoo.vespa.indexinglanguage.parser.IndexingParserTokenManager;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import com.yahoo.vespa.indexinglanguage.parser.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IndexingParser
implements IndexingParserConstants {
    private String defaultFieldName;
    private Linguistics linguistics;
    private Map<String, Embedder> embedders;
    private AnnotatorConfig annotatorCfg;
    public IndexingParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[35];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public IndexingParser(String str) {
        this(new IndexingInput(str));
    }

    public IndexingParser setDefaultFieldName(String fieldName) {
        this.defaultFieldName = fieldName;
        return this;
    }

    public IndexingParser setLinguistics(Linguistics linguistics) {
        this.linguistics = linguistics;
        return this;
    }

    public IndexingParser setEmbedders(Map<String, Embedder> embedders) {
        this.embedders = embedders;
        return this;
    }

    public IndexingParser setAnnotatorConfig(AnnotatorConfig cfg) {
        this.annotatorCfg = cfg;
        return this;
    }

    private static FieldValue parseDouble(String str) {
        return new DoubleFieldValue(new BigDecimal(str).doubleValue());
    }

    private static FieldValue parseFloat(String str) {
        if (str.endsWith("f") || str.endsWith("F")) {
            str = str.substring(0, str.length() - 1);
        }
        return new FloatFieldValue(new BigDecimal(str).floatValue());
    }

    private static FieldValue parseInteger(String str) {
        if (str.startsWith("0x")) {
            return new IntegerFieldValue(new BigInteger(str.substring(2), 16).intValue());
        }
        return new IntegerFieldValue(new BigInteger(str).intValue());
    }

    private static FieldValue parseLong(String str) {
        if (str.endsWith("l") || str.endsWith("L")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.startsWith("0x")) {
            return new LongFieldValue(new BigInteger(str.substring(2), 16).longValue());
        }
        return new LongFieldValue(new BigInteger(str).longValue());
    }

    public final Expression root() throws ParseException {
        StatementExpression exp = this.statement();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        while (exp instanceof ExpressionList && ((ExpressionList)exp).size() == 1) {
            exp = ((ExpressionList)exp).get(0);
        }
        return exp;
    }

    public final ScriptExpression script() throws ParseException {
        ArrayList<StatementExpression> lst = new ArrayList<StatementExpression>();
        this.jj_consume_token(24);
        this.nl();
        StatementExpression exp = this.statement();
        lst.add(exp);
        this.nl();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(31);
            this.nl();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 24: 
                case 26: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 38: 
                case 40: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: {
                    exp = this.statement();
                    lst.add(exp);
                    this.nl();
                    continue block6;
                }
            }
            this.jj_la1[2] = this.jj_gen;
        }
        this.jj_consume_token(25);
        return new ScriptExpression(lst);
    }

    public final StatementExpression statement() throws ParseException {
        ArrayList<Expression> lst = new ArrayList<Expression>();
        Expression exp = this.expression();
        lst.add(exp);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(23);
            this.nl();
            exp = this.expression();
            lst.add(exp);
        }
        return new StatementExpression(lst);
    }

    public final Expression expression() throws ParseException {
        ArrayList<Expression> choices = new ArrayList<Expression>();
        Expression choice = this.nonChoiceExpression();
        choices.add(choice);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            choice = this.nonChoiceExpression();
            choices.add(choice);
        }
        return choices.size() == 1 ? (Expression)((Object)choices.get(0)) : new ChoiceExpression(choices);
    }

    public final Expression nonChoiceExpression() throws ParseException {
        ArrayList<Expression> lst = new ArrayList<Expression>();
        Expression exp = this.math();
        lst.add(exp);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(28);
            exp = this.math();
            lst.add(exp);
        }
        return lst.size() == 1 ? exp : new CatExpression(lst);
    }

    public final Expression math() throws ParseException {
        ArithmeticExpression.Operator op = ArithmeticExpression.Operator.ADD;
        MathResolver math = new MathResolver();
        Expression exp = this.value();
        math.push(op, exp);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block10;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: {
                    this.jj_consume_token(11);
                    op = ArithmeticExpression.Operator.ADD;
                    break;
                }
                case 14: {
                    this.jj_consume_token(14);
                    op = ArithmeticExpression.Operator.DIV;
                    break;
                }
                case 15: {
                    this.jj_consume_token(15);
                    op = ArithmeticExpression.Operator.MOD;
                    break;
                }
                case 13: {
                    this.jj_consume_token(13);
                    op = ArithmeticExpression.Operator.MUL;
                    break;
                }
                case 12: {
                    this.jj_consume_token(12);
                    op = ArithmeticExpression.Operator.SUB;
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            exp = this.value();
            math.push(op, exp);
        }
        return math.resolve();
    }

    public final Expression value() throws ParseException {
        Expression val;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                val = this.attributeExp();
                break;
            }
            case 34: {
                val = this.base64DecodeExp();
                break;
            }
            case 35: {
                val = this.base64EncodeExp();
                break;
            }
            case 38: {
                val = this.clearStateExp();
                break;
            }
            case 40: {
                val = this.echoExp();
                break;
            }
            case 42: {
                val = this.embedExp();
                break;
            }
            case 43: {
                val = this.exactExp();
                break;
            }
            case 44: {
                val = this.flattenExp();
                break;
            }
            case 45: {
                val = this.forEachExp();
                break;
            }
            case 46: {
                val = this.getFieldExp();
                break;
            }
            case 47: {
                val = this.getVarExp();
                break;
            }
            case 48: {
                val = this.guardExp();
                break;
            }
            case 49: {
                val = this.hashExp();
                break;
            }
            case 50: {
                val = this.hexDecodeExp();
                break;
            }
            case 51: {
                val = this.hexEncodeExp();
                break;
            }
            case 52: {
                val = this.hostNameExp();
                break;
            }
            case 53: {
                val = this.ifThenExp();
                break;
            }
            case 54: {
                val = this.indexExp();
                break;
            }
            case 55: {
                val = this.inputExp();
                break;
            }
            case 56: {
                val = this.joinExp();
                break;
            }
            case 57: {
                val = this.lowerCaseExp();
                break;
            }
            case 60: {
                val = this.ngramExp();
                break;
            }
            case 61: {
                val = this.normalizeExp();
                break;
            }
            case 62: {
                val = this.nowExp();
                break;
            }
            case 63: {
                val = this.optimizePredicateExp();
                break;
            }
            case 64: {
                val = this.passthroughExp();
                break;
            }
            case 65: {
                val = this.randomExp();
                break;
            }
            case 24: {
                val = this.script();
                break;
            }
            case 67: {
                val = this.selectInputExp();
                break;
            }
            case 68: {
                val = this.setLanguageExp();
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 32: {
                val = this.setValueExp();
                break;
            }
            case 69: {
                val = this.setVarExp();
                break;
            }
            case 70: {
                val = this.splitExp();
                break;
            }
            case 72: {
                val = this.substringExp();
                break;
            }
            case 73: {
                val = this.summaryExp();
                break;
            }
            case 74: {
                val = this.switchExp();
                break;
            }
            case 75: {
                val = this.thisExp();
                break;
            }
            case 76: {
                val = this.tokenizeExp();
                break;
            }
            case 77: {
                val = this.toArrayExp();
                break;
            }
            case 78: {
                val = this.toByteExp();
                break;
            }
            case 79: {
                val = this.toDoubleExp();
                break;
            }
            case 80: {
                val = this.toFloatExp();
                break;
            }
            case 81: {
                val = this.toIntExp();
                break;
            }
            case 82: {
                val = this.toLongExp();
                break;
            }
            case 83: {
                val = this.toPosExp();
                break;
            }
            case 84: {
                val = this.toEpochSecondExp();
                break;
            }
            case 85: {
                val = this.toStringExp();
                break;
            }
            case 86: {
                val = this.toWsetExp();
                break;
            }
            case 87: {
                val = this.toBoolExp();
                break;
            }
            case 88: {
                val = this.trimExp();
                break;
            }
            case 90: 
            case 91: {
                val = this.literalBoolExp();
                break;
            }
            case 89: {
                val = this.zcurveExp();
                break;
            }
            case 92: {
                val = this.executionValueExp();
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                val = this.statement();
                this.jj_consume_token(27);
                val = new ParenthesisExpression(val);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final Expression attributeExp() throws ParseException {
        String val = this.defaultFieldName;
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: {
                val = this.fieldName();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        return new AttributeExpression(val);
    }

    public final Expression base64DecodeExp() throws ParseException {
        this.jj_consume_token(34);
        return new Base64DecodeExpression();
    }

    public final Expression base64EncodeExp() throws ParseException {
        this.jj_consume_token(35);
        return new Base64EncodeExpression();
    }

    public final Expression clearStateExp() throws ParseException {
        this.jj_consume_token(38);
        return new ClearStateExpression();
    }

    public final Expression echoExp() throws ParseException {
        this.jj_consume_token(40);
        return new EchoExpression();
    }

    public final Expression embedExp() throws ParseException {
        String embedderId = "";
        ArrayList<String> embedderArguments = new ArrayList<String>();
        this.jj_consume_token(42);
        if (this.jj_2_1(2)) {
            embedderId = this.identifier();
        }
        while (this.jj_2_2(2)) {
            String embedderArgument = this.identifier();
            embedderArguments.add(embedderArgument);
        }
        return new EmbedExpression(this.embedders, embedderId, embedderArguments);
    }

    public final Expression exactExp() throws ParseException {
        this.jj_consume_token(43);
        return new ExactExpression();
    }

    public final Expression flattenExp() throws ParseException {
        this.jj_consume_token(44);
        return new FlattenExpression();
    }

    public final Expression forEachExp() throws ParseException {
        this.jj_consume_token(45);
        this.jj_consume_token(24);
        this.nl();
        StatementExpression val = this.statement();
        this.nl();
        this.jj_consume_token(25);
        return new ForEachExpression(val);
    }

    public final Expression getFieldExp() throws ParseException {
        this.jj_consume_token(46);
        String val = this.identifier();
        return new GetFieldExpression(val);
    }

    public final Expression getVarExp() throws ParseException {
        this.jj_consume_token(47);
        String val = this.identifier();
        return new GetVarExpression(val);
    }

    public final Expression guardExp() throws ParseException {
        this.jj_consume_token(48);
        ScriptExpression val = this.script();
        return new GuardExpression(val);
    }

    public final Expression hashExp() throws ParseException {
        this.jj_consume_token(49);
        return new HashExpression();
    }

    public final Expression hexDecodeExp() throws ParseException {
        this.jj_consume_token(50);
        return new HexDecodeExpression();
    }

    public final Expression hexEncodeExp() throws ParseException {
        this.jj_consume_token(51);
        return new HexEncodeExpression();
    }

    public final Expression hostNameExp() throws ParseException {
        this.jj_consume_token(52);
        return new HostNameExpression();
    }

    public final Expression ifThenExp() throws ParseException {
        ScriptExpression ifFalse = null;
        this.jj_consume_token(53);
        this.jj_consume_token(26);
        Expression lhs = this.expression();
        IfThenExpression.Comparator cmp = this.ifThenCmp();
        Expression rhs = this.expression();
        this.jj_consume_token(27);
        ScriptExpression ifTrue = this.script();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                ifFalse = this.script();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        return new IfThenExpression(lhs, cmp, rhs, ifTrue, ifFalse);
    }

    public final IfThenExpression.Comparator ifThenCmp() throws ParseException {
        IfThenExpression.Comparator val = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                val = IfThenExpression.Comparator.EQ;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                val = IfThenExpression.Comparator.NE;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                val = IfThenExpression.Comparator.LE;
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                val = IfThenExpression.Comparator.LT;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                val = IfThenExpression.Comparator.GE;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                val = IfThenExpression.Comparator.GT;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return val;
    }

    public final Expression indexExp() throws ParseException {
        String val = this.defaultFieldName;
        this.jj_consume_token(54);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: {
                val = this.fieldName();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        return new IndexExpression(val);
    }

    public final Expression inputExp() throws ParseException {
        String val = this.defaultFieldName;
        this.jj_consume_token(55);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: {
                val = this.identifier();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        return new InputExpression(val);
    }

    public final Expression joinExp() throws ParseException {
        this.jj_consume_token(56);
        String val = this.string();
        return new JoinExpression(val);
    }

    public final Expression lowerCaseExp() throws ParseException {
        this.jj_consume_token(57);
        return new LowerCaseExpression();
    }

    public final Expression ngramExp() throws ParseException {
        this.jj_consume_token(60);
        int gramSize = this.integer();
        return new NGramExpression(this.linguistics, gramSize);
    }

    public final Expression normalizeExp() throws ParseException {
        this.jj_consume_token(61);
        return new NormalizeExpression(this.linguistics);
    }

    public final Expression nowExp() throws ParseException {
        this.jj_consume_token(62);
        return new NowExpression();
    }

    public final Expression optimizePredicateExp() throws ParseException {
        this.jj_consume_token(63);
        return new OptimizePredicateExpression();
    }

    public final Expression passthroughExp() throws ParseException {
        String val = this.defaultFieldName;
        this.jj_consume_token(64);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: {
                val = this.fieldName();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        return new PassthroughExpression(val);
    }

    public final Expression randomExp() throws ParseException {
        Integer val = null;
        this.jj_consume_token(65);
        if (this.jj_2_3(2)) {
            val = this.integer();
        }
        return new RandomExpression(val);
    }

    public final Expression selectInputExp() throws ParseException {
        ArrayList<Pair<String, Expression>> cases = new ArrayList<Pair<String, Expression>>();
        this.jj_consume_token(67);
        this.jj_consume_token(24);
        this.nl();
        block3: while (true) {
            String str = this.identifier();
            this.jj_consume_token(30);
            StatementExpression exp = this.statement();
            this.jj_consume_token(31);
            this.nl();
            cases.add(new Pair((Object)str, (Object)exp));
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 93: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[15] = this.jj_gen;
        this.jj_consume_token(25);
        return new SelectInputExpression(cases);
    }

    public final Expression setLanguageExp() throws ParseException {
        this.jj_consume_token(68);
        return new SetLanguageExpression();
    }

    public final Expression setValueExp() throws ParseException {
        FieldValue val = this.fieldValue();
        return new ConstantExpression(val);
    }

    public final Expression setVarExp() throws ParseException {
        this.jj_consume_token(69);
        String val = this.identifier();
        return new SetVarExpression(val);
    }

    public final Expression splitExp() throws ParseException {
        this.jj_consume_token(70);
        String val = this.string();
        return new SplitExpression(val);
    }

    public final Expression substringExp() throws ParseException {
        this.jj_consume_token(72);
        long from = this.integer();
        long to = this.integer();
        return new SubstringExpression((int)from, (int)to);
    }

    public final Expression summaryExp() throws ParseException {
        String val = this.defaultFieldName;
        this.jj_consume_token(73);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 93: {
                val = this.fieldName();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        return new SummaryExpression(val);
    }

    public final Expression switchExp() throws ParseException {
        LinkedHashMap<String, StatementExpression> cases = new LinkedHashMap<String, StatementExpression>();
        StatementExpression defaultExp = null;
        this.jj_consume_token(74);
        this.jj_consume_token(24);
        this.nl();
        block6: while (true) {
            this.jj_consume_token(36);
            String str = this.string();
            this.jj_consume_token(30);
            StatementExpression exp = this.statement();
            cases.put(str, exp);
            this.jj_consume_token(31);
            this.nl();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 36: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[17] = this.jj_gen;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                this.jj_consume_token(30);
                defaultExp = this.statement();
                this.jj_consume_token(31);
                this.nl();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(25);
        return new SwitchExpression(cases, defaultExp);
    }

    public final Expression thisExp() throws ParseException {
        this.jj_consume_token(75);
        return new ThisExpression();
    }

    public final Expression tokenizeExp() throws ParseException {
        AnnotatorConfig cfg = this.annotatorCfg;
        this.jj_consume_token(76);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 58: 
            case 59: 
            case 61: 
            case 71: {
                cfg = this.tokenizeCfg();
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        return new TokenizeExpression(this.linguistics, cfg);
    }

    public final AnnotatorConfig tokenizeCfg() throws ParseException {
        AnnotatorConfig val = new AnnotatorConfig(this.annotatorCfg);
        String str = "SHORTEST";
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 71: {
                    this.jj_consume_token(71);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 30: {
                            this.jj_consume_token(30);
                            str = this.string();
                            break;
                        }
                        default: {
                            this.jj_la1[20] = this.jj_gen;
                        }
                    }
                    val.setStemMode(str);
                    break;
                }
                case 58: {
                    this.jj_consume_token(58);
                    this.jj_consume_token(30);
                    Integer maxLength = this.integer();
                    val.setMaxTokenLength(maxLength);
                    break;
                }
                case 59: {
                    this.jj_consume_token(59);
                    this.jj_consume_token(30);
                    Integer maxTermOccurrences = this.integer();
                    val.setMaxTermOccurrences(maxTermOccurrences);
                    break;
                }
                case 61: {
                    this.jj_consume_token(61);
                    val.setRemoveAccents(true);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 58: 
                case 59: 
                case 61: 
                case 71: {
                    continue block12;
                }
            }
            break;
        }
        this.jj_la1[22] = this.jj_gen;
        return val;
    }

    public final Expression toArrayExp() throws ParseException {
        this.jj_consume_token(77);
        return new ToArrayExpression();
    }

    public final Expression toByteExp() throws ParseException {
        this.jj_consume_token(78);
        return new ToByteExpression();
    }

    public final Expression toDoubleExp() throws ParseException {
        this.jj_consume_token(79);
        return new ToDoubleExpression();
    }

    public final Expression toFloatExp() throws ParseException {
        this.jj_consume_token(80);
        return new ToFloatExpression();
    }

    public final Expression toIntExp() throws ParseException {
        this.jj_consume_token(81);
        return new ToIntegerExpression();
    }

    public final Expression toLongExp() throws ParseException {
        this.jj_consume_token(82);
        return new ToLongExpression();
    }

    public final Expression toPosExp() throws ParseException {
        this.jj_consume_token(83);
        return new ToPositionExpression();
    }

    public final Expression toEpochSecondExp() throws ParseException {
        this.jj_consume_token(84);
        return new ToEpochSecondExpression();
    }

    public final Expression toStringExp() throws ParseException {
        this.jj_consume_token(85);
        return new ToStringExpression();
    }

    public final Expression toWsetExp() throws ParseException {
        boolean removeIfZero;
        boolean createIfNonExistent;
        block8: {
            createIfNonExistent = false;
            removeIfZero = false;
            this.jj_consume_token(86);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: 
                    case 66: {
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        createIfNonExistent = true;
                        continue block7;
                    }
                    case 66: {
                        this.jj_consume_token(66);
                        removeIfZero = true;
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[24] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return new ToWsetExpression(createIfNonExistent, removeIfZero);
    }

    public final Expression toBoolExp() throws ParseException {
        this.jj_consume_token(87);
        return new ToBoolExpression();
    }

    public final Expression trimExp() throws ParseException {
        this.jj_consume_token(88);
        return new TrimExpression();
    }

    public final Expression literalBoolExp() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return new LiteralBoolExpression(Boolean.parseBoolean(this.token.image));
    }

    public final Expression zcurveExp() throws ParseException {
        this.jj_consume_token(89);
        return new ZCurveExpression();
    }

    public final Expression executionValueExp() throws ParseException {
        this.jj_consume_token(92);
        return new ExecutionValueExpression();
    }

    public final String identifier() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32 -> this.string();
            case 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 79, 80, 81, 82, 83, 85, 86, 87, 88, 89, 90, 91, 93 -> {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 33: {
                        this.jj_consume_token(33);
                        break;
                    }
                    case 34: {
                        this.jj_consume_token(34);
                        break;
                    }
                    case 35: {
                        this.jj_consume_token(35);
                        break;
                    }
                    case 36: {
                        this.jj_consume_token(36);
                        break;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        break;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        break;
                    }
                    case 39: {
                        this.jj_consume_token(39);
                        break;
                    }
                    case 40: {
                        this.jj_consume_token(40);
                        break;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        break;
                    }
                    case 41: {
                        this.jj_consume_token(41);
                        break;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        break;
                    }
                    case 44: {
                        this.jj_consume_token(44);
                        break;
                    }
                    case 45: {
                        this.jj_consume_token(45);
                        break;
                    }
                    case 46: {
                        this.jj_consume_token(46);
                        break;
                    }
                    case 47: {
                        this.jj_consume_token(47);
                        break;
                    }
                    case 48: {
                        this.jj_consume_token(48);
                        break;
                    }
                    case 49: {
                        this.jj_consume_token(49);
                        break;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        break;
                    }
                    case 51: {
                        this.jj_consume_token(51);
                        break;
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        break;
                    }
                    case 93: {
                        this.jj_consume_token(93);
                        break;
                    }
                    case 53: {
                        this.jj_consume_token(53);
                        break;
                    }
                    case 54: {
                        this.jj_consume_token(54);
                        break;
                    }
                    case 55: {
                        this.jj_consume_token(55);
                        break;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        break;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        break;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    case 60: {
                        this.jj_consume_token(60);
                        break;
                    }
                    case 61: {
                        this.jj_consume_token(61);
                        break;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        break;
                    }
                    case 63: {
                        this.jj_consume_token(63);
                        break;
                    }
                    case 64: {
                        this.jj_consume_token(64);
                        break;
                    }
                    case 65: {
                        this.jj_consume_token(65);
                        break;
                    }
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    case 67: {
                        this.jj_consume_token(67);
                        break;
                    }
                    case 68: {
                        this.jj_consume_token(68);
                        break;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        break;
                    }
                    case 71: {
                        this.jj_consume_token(71);
                        break;
                    }
                    case 72: {
                        this.jj_consume_token(72);
                        break;
                    }
                    case 73: {
                        this.jj_consume_token(73);
                        break;
                    }
                    case 74: {
                        this.jj_consume_token(74);
                        break;
                    }
                    case 75: {
                        this.jj_consume_token(75);
                        break;
                    }
                    case 77: {
                        this.jj_consume_token(77);
                        break;
                    }
                    case 79: {
                        this.jj_consume_token(79);
                        break;
                    }
                    case 80: {
                        this.jj_consume_token(80);
                        break;
                    }
                    case 81: {
                        this.jj_consume_token(81);
                        break;
                    }
                    case 82: {
                        this.jj_consume_token(82);
                        break;
                    }
                    case 83: {
                        this.jj_consume_token(83);
                        break;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        break;
                    }
                    case 86: {
                        this.jj_consume_token(86);
                        break;
                    }
                    case 87: {
                        this.jj_consume_token(87);
                        break;
                    }
                    case 76: {
                        this.jj_consume_token(76);
                        break;
                    }
                    case 88: {
                        this.jj_consume_token(88);
                        break;
                    }
                    case 90: {
                        this.jj_consume_token(90);
                        break;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        break;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        break;
                    }
                    default: {
                        this.jj_la1[26] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                yield this.token.image;
            }
            default -> {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final String fieldName() throws ParseException {
        StringBuilder builder = new StringBuilder();
        String str = this.identifier();
        builder.append(str);
        while (this.jj_2_4(2)) {
            this.jj_consume_token(28);
            builder.append(this.token.image);
            str = this.identifier();
            builder.append(str);
        }
        return builder.toString();
    }

    public final FieldValue fieldValue() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6, 7, 8, 9, 11, 12 -> this.numericValue();
            case 32 -> this.stringValue();
            default -> {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final FieldValue numericValue() throws ParseException {
        String pre = "";
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: 
            case 12: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        break block0;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        pre = "-";
                        break block0;
                    }
                }
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8 -> {
                this.jj_consume_token(8);
                yield IndexingParser.parseDouble(pre + this.token.image);
            }
            case 9 -> {
                this.jj_consume_token(9);
                yield IndexingParser.parseFloat(pre + this.token.image);
            }
            case 6 -> {
                this.jj_consume_token(6);
                yield IndexingParser.parseInteger(pre + this.token.image);
            }
            case 7 -> {
                this.jj_consume_token(7);
                yield IndexingParser.parseLong(pre + this.token.image);
            }
            default -> {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final FieldValue stringValue() throws ParseException {
        String val = this.string();
        return new StringFieldValue(val);
    }

    public final String string() throws ParseException {
        this.jj_consume_token(32);
        return StringUtilities.unescape((String)this.token.image.substring(1, this.token.image.length() - 1));
    }

    public final int integer() throws ParseException {
        String pre = "";
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: 
            case 12: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 11: {
                        this.jj_consume_token(11);
                        break block0;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        pre = "-";
                        break block0;
                    }
                }
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        this.jj_consume_token(6);
        int val = Integer.parseInt(pre + this.token.image);
        return val;
    }

    public final void nl() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_16()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_15() {
        return this.jj_3R_18();
    }

    private boolean jj_3R_19() {
        return this.jj_scan_token(12);
    }

    private boolean jj_3R_16() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(33)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(34)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(35)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(36)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(37)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(38)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(39)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(40)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(43)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(41)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(42)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(44)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(45)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(46)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(47)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(48)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(49)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(50)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(51)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(52)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(93)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(53)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(54)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(55)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(56)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(57)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(58)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(60)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(61)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(62)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(63)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(64)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(65)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(66)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(67)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(68)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(69)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(70)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(71)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(72)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(73)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(74)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(75)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(77)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(79)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(80)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(81)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(82)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(83)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(85)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(86)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(87)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(76)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(88)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(90)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(91)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(89)) {
                                                                                                                                                                                                                                            return true;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(6);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private boolean jj_3_1() {
        return this.jj_3R_13();
    }

    private boolean jj_3_3() {
        return this.jj_3R_14();
    }

    private boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(11)) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_19()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(32);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, 83893184, 0x800000, 0x400000, 0x10000000, 63488, 63488, 83893184, 0, 0, 0x3F0000, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 7104, 6144, 6144, 960, 6144, 6144, 1024};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, -201327281, 0, 0, 0, 0, 0, -201327281, -134217729, 512, 0, -134217729, -134217729, -134217729, -134217729, -134217729, 16, 32, 0x2C000000, 0, 0x2C000000, 0x2C000000, 128, 128, 0, -134217730, -134217729, 1, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 536870779, 0, 0, 0, 0, 0, 536870779, 804241407, 0, 0, 804241407, 804241407, 804241407, 804241407, 804241407, 0, 0, 128, 0, 128, 128, 4, 4, 0xC000000, 804241407, 804241407, 0, 0, 0, 0, 0, 0, 0};
    }

    public IndexingParser(CharStream stream) {
        int i;
        this.token_source = new IndexingParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 35; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 35; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public IndexingParser(IndexingParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 35; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(IndexingParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 35; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        int ret;
        this.jj_nt = this.token.next;
        Token nt = this.jj_nt;
        if (nt == null) {
            this.token.next = this.token_source.getNextToken();
            ret = this.jj_ntk = this.token.next.kind;
        } else {
            ret = this.jj_ntk = nt.kind;
        }
        return ret;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[94];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 35; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 94; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_scanpos = p.first;
                    this.jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        IndexingParser.jj_la1_init_0();
        IndexingParser.jj_la1_init_1();
        IndexingParser.jj_la1_init_2();
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

