/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.linguistics;

import com.yahoo.language.Language;
import com.yahoo.language.process.StemMode;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;

public class AnnotatorConfig
implements Cloneable {
    private Language language;
    private StemMode stemMode;
    private boolean removeAccents;
    private int maxTermOccurrences;
    private int maxTokenizeLength;
    public static final int DEFAULT_MAX_TERM_OCCURRENCES;
    private static final int DEFAULT_MAX_TOKENIZE_LENGTH;

    public AnnotatorConfig() {
        this.language = Language.ENGLISH;
        this.stemMode = StemMode.NONE;
        this.removeAccents = false;
        this.maxTermOccurrences = DEFAULT_MAX_TERM_OCCURRENCES;
        this.maxTokenizeLength = DEFAULT_MAX_TOKENIZE_LENGTH;
    }

    public AnnotatorConfig(AnnotatorConfig rhs) {
        this.language = rhs.language;
        this.stemMode = rhs.stemMode;
        this.removeAccents = rhs.removeAccents;
        this.maxTermOccurrences = rhs.maxTermOccurrences;
        this.maxTokenizeLength = rhs.maxTokenizeLength;
    }

    public Language getLanguage() {
        return this.language;
    }

    public AnnotatorConfig setLanguage(Language language) {
        this.language = language;
        return this;
    }

    public StemMode getStemMode() {
        return this.stemMode;
    }

    public AnnotatorConfig setStemMode(StemMode stemMode) {
        this.stemMode = stemMode;
        return this;
    }

    public AnnotatorConfig setStemMode(String name) {
        this.stemMode = StemMode.valueOf((String)name);
        return this;
    }

    public boolean getRemoveAccents() {
        return this.removeAccents;
    }

    public AnnotatorConfig setRemoveAccents(boolean removeAccents) {
        this.removeAccents = removeAccents;
        return this;
    }

    public int getMaxTermOccurrences() {
        return this.maxTermOccurrences;
    }

    public AnnotatorConfig setMaxTermOccurrences(int maxTermCount) {
        this.maxTermOccurrences = maxTermCount;
        return this;
    }

    public AnnotatorConfig setMaxTokenLength(int maxTokenizeLength) {
        this.maxTokenizeLength = maxTokenizeLength;
        return this;
    }

    public int getMaxTokenizeLength() {
        return this.maxTokenizeLength;
    }

    public boolean hasNonDefaultMaxTokenLength() {
        return this.maxTokenizeLength != DEFAULT_MAX_TOKENIZE_LENGTH;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnotatorConfig)) {
            return false;
        }
        AnnotatorConfig rhs = (AnnotatorConfig)obj;
        if (!this.language.equals((Object)rhs.language)) {
            return false;
        }
        if (!this.stemMode.equals((Object)rhs.stemMode)) {
            return false;
        }
        if (this.removeAccents != rhs.removeAccents) {
            return false;
        }
        if (this.maxTermOccurrences != rhs.maxTermOccurrences) {
            return false;
        }
        return this.maxTokenizeLength == rhs.maxTokenizeLength;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.language.hashCode() + this.stemMode.hashCode() + Boolean.valueOf(this.removeAccents).hashCode() + this.maxTermOccurrences + this.maxTokenizeLength;
    }

    static {
        IlscriptsConfig defaults = new IlscriptsConfig(new IlscriptsConfig.Builder());
        DEFAULT_MAX_TERM_OCCURRENCES = defaults.maxtermoccurrences();
        DEFAULT_MAX_TOKENIZE_LENGTH = defaults.fieldmatchmaxlength();
    }
}

