/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.FieldPath;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class InputExpression
extends Expression {
    private final String fieldName;
    private FieldPath fieldPath;

    public InputExpression(String fieldName) {
        super(null);
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        if (this.fieldPath != null) {
            context.setValue(context.getInputValue(this.fieldPath));
        } else {
            context.setValue(context.getInputValue(this.fieldName));
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType val = context.getInputType(this, this.fieldName);
        if (val == null) {
            throw new VerificationException(this, "Field '" + this.fieldName + "' not found.");
        }
        context.setValueType(val);
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "input" + (String)(this.fieldName != null ? " " + this.fieldName : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InputExpression)) {
            return false;
        }
        InputExpression rhs = (InputExpression)((Object)obj);
        return InputExpression.equals(this.fieldName, rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + (this.fieldName != null ? this.fieldName.hashCode() : 0);
    }

    public static class InputFieldNameExtractor
    implements ObjectOperation,
    ObjectPredicate {
        private final List<String> inputFieldNames = new ArrayList<String>(1);

        public void execute(Object obj) {
            this.inputFieldNames.add(((InputExpression)((Object)obj)).getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }

        public static List<String> runOn(Expression expression) {
            InputFieldNameExtractor inputFieldNameExtractor = new InputFieldNameExtractor();
            expression.select(inputFieldNameExtractor, inputFieldNameExtractor);
            return inputFieldNameExtractor.inputFieldNames;
        }
    }

    public static class FieldPathOptimizer
    implements ObjectOperation,
    ObjectPredicate {
        private final DocumentType documentType;

        public FieldPathOptimizer(DocumentType documentType) {
            this.documentType = documentType;
        }

        public void execute(Object obj) {
            InputExpression exp = (InputExpression)((Object)obj);
            exp.fieldPath = this.documentType.buildFieldPath(exp.getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }
    }
}

