/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class ChoiceExpression
extends ExpressionList<Expression> {
    public ChoiceExpression() {
        this(List.of());
    }

    public ChoiceExpression(Expression ... choices) {
        this(Arrays.asList(choices));
    }

    public ChoiceExpression(Collection<? extends Expression> choices) {
        super(choices, ChoiceExpression.resolveInputType(choices));
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        FieldValue input = context.getValue();
        for (Expression expression : this) {
            context.setValue(input).execute(expression);
            if (context.getValue() == null) continue;
            break;
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValueType();
        for (Expression exp : this) {
            context.setValueType(input).execute(exp);
        }
        context.setValueType(input);
    }

    private static DataType resolveInputType(Collection<? extends Expression> list) {
        DataType previousInput = null;
        DataType previousOutput = null;
        for (Expression expression : list) {
            DataType thisInput = expression.requiredInputType();
            if (previousInput == null) {
                previousInput = thisInput;
            } else if (thisInput != null && !previousInput.isAssignableFrom(thisInput)) {
                throw new VerificationException(ScriptExpression.class, "Choice expression require conflicting input types, " + previousInput.getName() + " vs " + thisInput.getName() + ".");
            }
            DataType thisOutput = expression.createdOutputType();
            if (previousOutput == null) {
                previousOutput = thisOutput;
                continue;
            }
            if (thisOutput == null || previousOutput.isAssignableFrom(thisOutput)) continue;
            throw new VerificationException(ScriptExpression.class, "Choice expression produce conflicting output types, " + previousOutput.getName() + " vs " + thisOutput.getName() + ".");
        }
        return previousInput;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return this.asList().stream().map(Object::toString).collect(Collectors.joining(" || "));
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof ChoiceExpression;
    }
}

