/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public final class HexEncodeExpression
extends Expression {
    public HexEncodeExpression() {
        super((DataType)DataType.LONG);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        long input = ((LongFieldValue)context.getValue()).getLong();
        context.setValue((FieldValue)new StringFieldValue(Long.toHexString(input)));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "hexencode";
    }

    public boolean equals(Object obj) {
        return obj instanceof HexEncodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

