/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.UpdateAdapter;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetLanguageExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;

public final class GuardExpression
extends CompositeExpression {
    private final Expression exp;
    private final boolean shouldExecute;

    public GuardExpression(Expression exp) {
        super(exp.requiredInputType());
        this.exp = exp;
        this.shouldExecute = GuardExpression.shouldExecute(exp);
    }

    public Expression getInnerExpression() {
        return this.exp;
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.exp.setStatementOutput(documentType, field);
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        if (!this.shouldExecute && context.getAdapter() instanceof UpdateAdapter) {
            context.setValue(null);
        } else {
            this.exp.execute(context);
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        this.exp.verify(context);
    }

    @Override
    public DataType createdOutputType() {
        return this.exp.createdOutputType();
    }

    public String toString() {
        return "guard " + GuardExpression.toScriptBlock(this.exp);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        GuardExpression.select((Selectable)this.exp, (ObjectPredicate)predicate, (ObjectOperation)operation);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GuardExpression)) {
            return false;
        }
        GuardExpression rhs = (GuardExpression)((Object)obj);
        return ((Object)((Object)this.exp)).equals((Object)rhs.exp);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + ((Object)((Object)this.exp)).hashCode();
    }

    private static boolean shouldExecute(Expression exp) {
        ExecutionGuard guard = new ExecutionGuard();
        guard.visit(exp);
        return guard.shouldExecute;
    }

    private static class ExecutionGuard
    extends ExpressionVisitor {
        boolean shouldExecute = false;

        private ExecutionGuard() {
        }

        @Override
        protected void doVisit(Expression exp) {
            if (exp instanceof InputExpression || exp instanceof SetLanguageExpression) {
                this.shouldExecute = true;
            }
        }
    }
}

