/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.Field;
import com.yahoo.document.TensorDataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.language.process.Embedder;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;

public class EmbedExpression
extends Expression {
    private final Embedder embedder;
    private String destination;
    private TensorType targetType;

    public EmbedExpression(Embedder embedder) {
        super((DataType)DataType.STRING);
        this.embedder = embedder;
    }

    @Override
    public void setStatementOutput(DocumentType documentType, Field field) {
        this.targetType = ((TensorDataType)field.getDataType()).getTensorType();
        this.destination = documentType.getName() + "." + field.getName();
    }

    @Override
    protected void doExecute(ExecutionContext context) {
        StringFieldValue input = (StringFieldValue)context.getValue();
        Tensor tensor = this.embedder.embed(input.getString(), new Embedder.Context(this.destination).setLanguage(context.getLanguage()), this.targetType);
        context.setValue((FieldValue)new TensorFieldValue(tensor));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        String outputField = context.getOutputField();
        if (outputField == null) {
            throw new VerificationException(this, "No output field in this statement: Don't know what tensor type to embed into.");
        }
        DataType outputFieldType = context.getInputType(this, outputField);
        if (!(outputFieldType instanceof TensorDataType)) {
            throw new VerificationException(this, "The type of the output field " + outputField + " is not a tensor but " + outputField);
        }
        this.targetType = ((TensorDataType)outputFieldType).getTensorType();
        context.setValueType(this.createdOutputType());
    }

    @Override
    public DataType createdOutputType() {
        return new TensorDataType(this.targetType);
    }

    public String toString() {
        return "embed";
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object o) {
        return o instanceof EmbedExpression;
    }
}

