/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;

public abstract class OutputExpression
extends Expression {
    private final String image;
    private final String fieldName;

    public OutputExpression(String image, String fieldName) {
        super((DataType)UnresolvedDataType.INSTANCE);
        this.image = image;
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        ctx.setOutputValue(this, this.fieldName, ctx.getValue());
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.tryOutputType(this, this.fieldName, context.getValue());
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        return this.image + (String)(this.fieldName != null ? " " + this.fieldName : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OutputExpression)) {
            return false;
        }
        OutputExpression rhs = (OutputExpression)((Object)obj);
        return OutputExpression.equals(this.fieldName, rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + (this.fieldName != null ? this.fieldName.hashCode() : 0);
    }
}

