/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.DocumentType;
import com.yahoo.document.FieldPath;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.UnresolvedDataType;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import java.util.ArrayList;
import java.util.List;

public class InputExpression
extends Expression {
    private final String fieldName;
    private FieldPath fieldPath;

    public InputExpression(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        if (this.fieldPath != null) {
            ctx.setValue(ctx.getInputValue(this.fieldPath));
        } else {
            ctx.setValue(ctx.getInputValue(this.fieldName));
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType val = context.getInputType(this, this.fieldName);
        if (val == null) {
            throw new VerificationException(this, "Field '" + this.fieldName + "' not found.");
        }
        context.setValue(val);
    }

    @Override
    public DataType requiredInputType() {
        return null;
    }

    @Override
    public DataType createdOutputType() {
        return UnresolvedDataType.INSTANCE;
    }

    public String toString() {
        return "input" + (this.fieldName != null ? " " + this.fieldName : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InputExpression)) {
            return false;
        }
        InputExpression rhs = (InputExpression)((Object)obj);
        return InputExpression.equals(this.fieldName, rhs.fieldName);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + (this.fieldName != null ? this.fieldName.hashCode() : 0);
    }

    public static class InputFieldNameExtractor
    implements ObjectOperation,
    ObjectPredicate {
        private List<String> inputFieldNames = new ArrayList<String>(1);

        public List<String> getInputFieldNames() {
            return this.inputFieldNames;
        }

        public void execute(Object obj) {
            this.inputFieldNames.add(((InputExpression)((Object)obj)).getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }
    }

    public static class FieldPathOptimizer
    implements ObjectOperation,
    ObjectPredicate {
        private final DocumentType documentType;

        public FieldPathOptimizer(DocumentType documentType) {
            this.documentType = documentType;
        }

        public void execute(Object obj) {
            InputExpression exp = (InputExpression)((Object)obj);
            exp.fieldPath = this.documentType.buildFieldPath(exp.getFieldName());
        }

        public boolean check(Object obj) {
            return obj instanceof InputExpression;
        }
    }
}

