/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.indexinglanguage.expressions.CompositeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.Selectable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class SwitchExpression
extends CompositeExpression {
    private final Map<String, Expression> cases = new LinkedHashMap<String, Expression>();
    private final Expression defaultExp;

    public <T extends Expression> SwitchExpression(Map<String, T> cases) {
        this(cases, null);
    }

    public <T extends Expression> SwitchExpression(Map<String, T> cases, Expression defaultExp) {
        this.defaultExp = defaultExp;
        for (Map.Entry<String, T> entry : cases.entrySet()) {
            this.cases.put(entry.getKey(), (Expression)((Object)entry.getValue()));
        }
    }

    public boolean isEmpty() {
        return this.defaultExp == null && this.cases.isEmpty();
    }

    public Map<String, Expression> getCases() {
        return Collections.unmodifiableMap(this.cases);
    }

    public Expression getDefaultExpression() {
        return this.defaultExp;
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        Expression exp = null;
        if (input != null) {
            if (!(input instanceof StringFieldValue)) {
                throw new IllegalArgumentException("Expected " + DataType.STRING.getName() + " input, got " + input.getDataType().getName() + ".");
            }
            exp = this.cases.get(String.valueOf(input));
        }
        if (exp == null) {
            exp = this.defaultExp;
        }
        if (exp != null) {
            exp.execute(ctx);
        }
        ctx.setValue(input);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        SwitchExpression.select((Selectable)this.defaultExp, (ObjectPredicate)predicate, (ObjectOperation)operation);
        for (Expression exp : this.cases.values()) {
            SwitchExpression.select((Selectable)exp, (ObjectPredicate)predicate, (ObjectOperation)operation);
        }
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        if (input == null) {
            throw new VerificationException(this, "Expected " + DataType.STRING.getName() + " input, got null.");
        }
        if (input != DataType.STRING) {
            throw new VerificationException(this, "Expected " + DataType.STRING.getName() + " input, got " + input.getName() + ".");
        }
        for (Expression exp : this.cases.values()) {
            context.setValue(input).execute(exp);
        }
        context.setValue(input).execute(this.defaultExp);
        context.setValue(input);
    }

    @Override
    public DataType requiredInputType() {
        return null;
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("switch { ");
        for (Map.Entry<String, Expression> entry : this.cases.entrySet()) {
            ret.append("case \"").append(StringUtilities.escape((String)entry.getKey(), (char)'\"')).append("\": ");
            Expression exp = entry.getValue();
            ret.append((Object)exp).append("; ");
        }
        if (this.defaultExp != null) {
            ret.append("default: ").append((Object)this.defaultExp).append("; ");
        }
        ret.append("}");
        return ret.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SwitchExpression)) {
            return false;
        }
        SwitchExpression rhs = (SwitchExpression)((Object)obj);
        if (!this.cases.equals(rhs.cases)) {
            return false;
        }
        return SwitchExpression.equals((Object)this.defaultExp, (Object)rhs.defaultExp);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() + (this.defaultExp != null ? ((Object)((Object)this.defaultExp)).hashCode() : 0);
    }
}

