/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import java.math.BigInteger;

public class HexDecodeExpression
extends Expression {
    private static final BigInteger ULONG_MAX = new BigInteger("18446744073709551616");

    @Override
    protected void doExecute(ExecutionContext ctx) {
        BigInteger output;
        String input = String.valueOf(ctx.getValue());
        if (input.isEmpty()) {
            ctx.setValue((FieldValue)new LongFieldValue(Long.MIN_VALUE));
            return;
        }
        try {
            output = new BigInteger(input, 16);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Illegal hex value '" + input + "'.");
        }
        if (output.bitLength() > 64) {
            throw new NumberFormatException("Hex value '" + input + "' is out of range.");
        }
        if (output.compareTo(BigInteger.ZERO) == 1 && output.bitLength() == 64) {
            output = output.subtract(ULONG_MAX);
        }
        ctx.setValue((FieldValue)new LongFieldValue(output.longValue()));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType requiredInputType() {
        return DataType.STRING;
    }

    @Override
    public DataType createdOutputType() {
        return DataType.LONG;
    }

    public String toString() {
        return "hexdecode";
    }

    public boolean equals(Object obj) {
        return obj instanceof HexDecodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

