/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.language.Linguistics;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.vespa.indexinglanguage.ScriptParser;
import com.yahoo.vespa.indexinglanguage.ScriptParserContext;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ExpressionList;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationException;
import com.yahoo.vespa.indexinglanguage.parser.IndexingInput;
import com.yahoo.vespa.indexinglanguage.parser.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ScriptExpression
extends ExpressionList<StatementExpression> {
    public ScriptExpression() {
    }

    public ScriptExpression(StatementExpression ... lst) {
        super(Arrays.asList(lst));
    }

    public ScriptExpression(Collection<? extends StatementExpression> lst) {
        super(lst);
    }

    @Override
    protected void doExecute(ExecutionContext ctx) {
        FieldValue input = ctx.getValue();
        for (Expression exp : this) {
            ctx.setValue(input).execute(exp);
        }
        ctx.setValue(input);
    }

    @Override
    protected void doVerify(VerificationContext context) {
        DataType input = context.getValue();
        for (Expression exp : this) {
            context.setValue(input).execute(exp);
        }
        context.setValue(input);
    }

    @Override
    public DataType requiredInputType() {
        DataType prev = null;
        for (Expression exp : this) {
            DataType next = exp.requiredInputType();
            if (prev == null) {
                prev = next;
                continue;
            }
            if (next == null || prev.isAssignableFrom(next)) continue;
            throw new VerificationException(this, "Statements require conflicting input types, " + prev.getName() + " vs " + next.getName() + ".");
        }
        return prev;
    }

    @Override
    public DataType createdOutputType() {
        return null;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("{ ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ret.append(it.next()).append(";");
            if (!it.hasNext()) continue;
            ret.append(" ");
        }
        ret.append(" }");
        return ret.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof ScriptExpression;
    }

    public static ScriptExpression fromString(String expression) throws ParseException {
        return ScriptExpression.fromString(expression, (Linguistics)new SimpleLinguistics());
    }

    public static ScriptExpression fromString(String expression, Linguistics linguistics) throws ParseException {
        return ScriptExpression.newInstance(new ScriptParserContext(linguistics).setInputStream(new IndexingInput(expression)));
    }

    public static ScriptExpression newInstance(ScriptParserContext config) throws ParseException {
        return ScriptParser.parseScript(config);
    }
}

