/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.indexinglanguage.expressions;

import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.vespa.indexinglanguage.expressions.ExecutionContext;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.VerificationContext;
import org.apache.commons.codec.binary.Base64;

public class Base64EncodeExpression
extends Expression {
    @Override
    protected void doExecute(ExecutionContext ctx) {
        long input = ((LongFieldValue)ctx.getValue()).getLong();
        byte[] output = new byte[8];
        for (int i = 0; i < output.length; ++i) {
            output[i] = (byte)(input & 0xFFL);
            input >>>= 8;
        }
        String encoded = new Base64(0).encodeToString(output);
        ctx.setValue((FieldValue)new StringFieldValue(encoded));
    }

    @Override
    protected void doVerify(VerificationContext context) {
        context.setValue(this.createdOutputType());
    }

    @Override
    public DataType requiredInputType() {
        return DataType.LONG;
    }

    @Override
    public DataType createdOutputType() {
        return DataType.STRING;
    }

    public String toString() {
        return "base64encode";
    }

    public boolean equals(Object obj) {
        return obj instanceof Base64EncodeExpression;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

