/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http.hc5;

import ai.vespa.util.http.hc5.HttpToHttpsRoutePlanner;
import com.yahoo.security.tls.MixedMode;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.security.tls.TransportSecurityUtils;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;

public class VespaAsyncHttpClientBuilder {
    public static HttpAsyncClientBuilder create() {
        return VespaAsyncHttpClientBuilder.create(tlsStrategy -> PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build());
    }

    public static HttpAsyncClientBuilder create(AsyncConnectionManagerFactory factory) {
        return VespaAsyncHttpClientBuilder.create(factory, (HostnameVerifier)new NoopHostnameVerifier());
    }

    public static HttpAsyncClientBuilder create(AsyncConnectionManagerFactory factory, HostnameVerifier hostnameVerifier) {
        TlsStrategy tlsStrategy;
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClientBuilder.create();
        TlsContext vespaTlsContext = TransportSecurityUtils.getSystemTlsContext().orElse(null);
        if (vespaTlsContext != null) {
            SSLParameters vespaTlsParameters = vespaTlsContext.parameters();
            tlsStrategy = ClientTlsStrategyBuilder.create().setHostnameVerifier(hostnameVerifier).setSslContext(vespaTlsContext.sslContext().context()).setTlsVersions(vespaTlsParameters.getProtocols()).setCiphers(vespaTlsParameters.getCipherSuites()).build();
            if (TransportSecurityUtils.getInsecureMixedMode() != MixedMode.PLAINTEXT_CLIENT_MIXED_SERVER) {
                clientBuilder.setRoutePlanner((HttpRoutePlanner)new HttpToHttpsRoutePlanner());
            }
        } else {
            tlsStrategy = ClientTlsStrategyBuilder.create().build();
        }
        clientBuilder.disableConnectionState();
        clientBuilder.disableCookieManagement();
        clientBuilder.disableAuthCaching();
        clientBuilder.disableRedirectHandling();
        clientBuilder.setConnectionManager(factory.create(tlsStrategy));
        clientBuilder.setConnectionManagerShared(false);
        return clientBuilder;
    }

    public static interface AsyncConnectionManagerFactory {
        public AsyncClientConnectionManager create(TlsStrategy var1);
    }
}

