/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http.hc4.retry;

import java.time.Duration;

@FunctionalInterface
interface DelaySupplier {
    public Duration getDelay(int var1);

    public static class Exponential
    implements DelaySupplier {
        private final Duration startDelay;
        private final Duration maxDelay;

        Exponential(Duration startDelay, Duration maxDelay) {
            this.startDelay = startDelay;
            this.maxDelay = maxDelay;
        }

        @Override
        public Duration getDelay(int executionCount) {
            Duration nextDelay = this.startDelay;
            for (int i = 1; i < executionCount; ++i) {
                nextDelay = nextDelay.multipliedBy(2L);
            }
            return this.maxDelay.compareTo(nextDelay) > 0 ? nextDelay : this.maxDelay;
        }
    }

    public static class Fixed
    implements DelaySupplier {
        private final Duration delay;

        Fixed(Duration delay) {
            this.delay = delay;
        }

        @Override
        public Duration getDelay(int executionCount) {
            return this.delay;
        }
    }
}

