/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.util.http.retry;

import ai.vespa.util.http.retry.DelaySupplier;
import ai.vespa.util.http.retry.RetryConsumer;
import ai.vespa.util.http.retry.RetryFailedConsumer;
import ai.vespa.util.http.retry.RetryPredicate;
import ai.vespa.util.http.retry.Sleeper;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DelayedConnectionLevelRetryHandler
implements HttpRequestRetryHandler {
    private static final Logger log = Logger.getLogger(HttpRequestRetryHandler.class.getName());
    private final DelaySupplier delaySupplier;
    private final int maxRetries;
    private final RetryPredicate<IOException> predicate;
    private final RetryConsumer<IOException> retryConsumer;
    private final RetryFailedConsumer<IOException> retryFailedConsumer;
    private final Sleeper sleeper;

    private DelayedConnectionLevelRetryHandler(DelaySupplier delaySupplier, int maxRetries, RetryPredicate<IOException> predicate, RetryConsumer<IOException> retryConsumer, RetryFailedConsumer<IOException> retryFailedConsumer, Sleeper sleeper) {
        this.delaySupplier = delaySupplier;
        this.maxRetries = maxRetries;
        this.predicate = predicate;
        this.retryConsumer = retryConsumer;
        this.retryFailedConsumer = retryFailedConsumer;
        this.sleeper = sleeper;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext ctx) {
        log.fine(() -> String.format("retryRequest(exception='%s', executionCount='%d', ctx='%s'", exception.getClass().getName(), executionCount, ctx));
        HttpClientContext clientCtx = HttpClientContext.adapt((HttpContext)ctx);
        if (!this.predicate.test(exception, clientCtx)) {
            log.fine(() -> String.format("Not retrying for '%s'", ctx));
            return false;
        }
        if (executionCount > this.maxRetries) {
            log.fine(() -> String.format("Max retries exceeded for '%s'", ctx));
            this.retryFailedConsumer.onRetryFailed(exception, executionCount, clientCtx);
            return false;
        }
        Duration delay = this.delaySupplier.getDelay(executionCount);
        log.fine(() -> String.format("Retrying after %s for '%s'", delay, ctx));
        this.retryConsumer.onRetry(exception, delay, executionCount, clientCtx);
        this.sleeper.sleep(delay);
        return true;
    }

    public static class Builder {
        private final DelaySupplier delaySupplier;
        private final int maxRetries;
        private RetryPredicate<IOException> predicate = (ioException, ctx) -> true;
        private RetryConsumer<IOException> retryConsumer = (exception, delay, count, ctx) -> {};
        private RetryFailedConsumer<IOException> retryFailedConsumer = (exception, count, ctx) -> {};
        private Sleeper sleeper = new Sleeper.Default();

        private Builder(DelaySupplier delaySupplier, int maxRetries) {
            this.delaySupplier = delaySupplier;
            this.maxRetries = maxRetries;
        }

        public static Builder withFixedDelay(Duration delay, int maxRetries) {
            return new Builder(new DelaySupplier.Fixed(delay), maxRetries);
        }

        public static Builder withExponentialBackoff(Duration startDelay, Duration maxDelay, int maxRetries) {
            return new Builder(new DelaySupplier.Exponential(startDelay, maxDelay), maxRetries);
        }

        public Builder retryForExceptions(List<Class<? extends IOException>> exceptionTypes) {
            this.predicate = (ioException, ctx) -> exceptionTypes.stream().anyMatch(type -> type.isInstance(ioException));
            return this;
        }

        public Builder retryForExceptions(Predicate<IOException> predicate) {
            this.predicate = (ioException, ctx) -> predicate.test((IOException)ioException);
            return this;
        }

        public Builder retryFor(RetryPredicate<IOException> predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder onRetry(RetryConsumer<IOException> consumer) {
            this.retryConsumer = consumer;
            return this;
        }

        public Builder onRetryFailed(RetryFailedConsumer<IOException> consumer) {
            this.retryFailedConsumer = consumer;
            return this;
        }

        Builder withSleeper(Sleeper sleeper) {
            this.sleeper = sleeper;
            return this;
        }

        public DelayedConnectionLevelRetryHandler build() {
            return new DelayedConnectionLevelRetryHandler(this.delaySupplier, this.maxRetries, this.predicate, this.retryConsumer, this.retryFailedConsumer, this.sleeper);
        }
    }
}

