/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.hosted.testrunner;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.PathNode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public final class TestRunnerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "40a7c0c8b402111d07f7c398a456c3dc";
    public static final String CONFIG_DEF_NAME = "test-runner";
    public static final String CONFIG_DEF_NAMESPACE = "com.yahoo.vespa.hosted.testrunner";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=com.yahoo.vespa.hosted.testrunner", "artifactsPath path", "surefireMemoryMb int"};
    private final PathNode artifactsPath;
    private final IntegerNode surefireMemoryMb;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public TestRunnerConfig(Builder builder) {
        this(builder, true);
    }

    private TestRunnerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for test-runner must be initialized: " + builder.__uninitialized);
        }
        this.artifactsPath = builder.artifactsPath == null ? new PathNode() : new PathNode(builder.artifactsPath);
        this.surefireMemoryMb = builder.surefireMemoryMb == null ? new IntegerNode() : new IntegerNode(builder.surefireMemoryMb.intValue());
    }

    public Path artifactsPath() {
        return this.artifactsPath.value();
    }

    public int surefireMemoryMb() {
        return this.surefireMemoryMb.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(TestRunnerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("artifactsPath", "surefireMemoryMb"));
        private FileReference artifactsPath = null;
        private Integer surefireMemoryMb = null;

        public Builder() {
        }

        public Builder(TestRunnerConfig config) {
            this.artifactsPath(config.artifactsPath.getFileReference());
            this.surefireMemoryMb(config.surefireMemoryMb());
        }

        private Builder override(Builder __superior) {
            if (__superior.artifactsPath != null) {
                this.artifactsPath(__superior.artifactsPath);
            }
            if (__superior.surefireMemoryMb != null) {
                this.surefireMemoryMb(__superior.surefireMemoryMb);
            }
            return this;
        }

        public Builder artifactsPath(FileReference __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.artifactsPath = __value;
            this.__uninitialized.remove("artifactsPath");
            return this;
        }

        public Builder surefireMemoryMb(int __value) {
            this.surefireMemoryMb = __value;
            this.__uninitialized.remove("surefireMemoryMb");
            return this;
        }

        private Builder surefireMemoryMb(String __value) {
            return this.surefireMemoryMb(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return TestRunnerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return TestRunnerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return TestRunnerConfig.CONFIG_DEF_NAMESPACE;
        }

        public TestRunnerConfig build() {
            return new TestRunnerConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

