/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.hosted.testrunner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.io.IOUtils;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.hosted.testrunner.TestProfile;
import com.yahoo.vespa.hosted.testrunner.TestRunner;
import com.yahoo.yolean.Exceptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TestRunnerHandler
extends LoggingRequestHandler {
    private static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    private final TestRunner testRunner;

    @Inject
    public TestRunnerHandler(Executor executor, AccessLog accessLog, TestRunner testRunner) {
        super(executor, accessLog);
        this.testRunner = testRunner;
    }

    public HttpResponse handle(HttpRequest request) {
        try {
            switch (request.getMethod()) {
                case GET: {
                    return this.handleGET(request);
                }
                case POST: {
                    return this.handlePOST(request);
                }
            }
            return new Response(405, "Method '" + request.getMethod() + "' is not supported");
        }
        catch (IllegalArgumentException e) {
            return new Response(400, Exceptions.toMessageString((Throwable)e));
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unexpected error handling '" + request.getUri() + "'", e);
            return new Response(500, Exceptions.toMessageString((Throwable)e));
        }
    }

    private HttpResponse handleGET(HttpRequest request) {
        String path = request.getUri().getPath();
        if (path.equals("/tester/v1/log")) {
            return new SlimeJsonResponse(TestRunnerHandler.logToSlime(this.testRunner.getLog(request.hasProperty("after") ? Long.parseLong(request.getProperty("after")) : -1L)));
        }
        if (path.equals("/tester/v1/status")) {
            this.log.info("Responding with status " + this.testRunner.getStatus());
            return new Response(this.testRunner.getStatus().name());
        }
        return new Response(404, "Not found: " + request.getUri().getPath());
    }

    private HttpResponse handlePOST(HttpRequest request) throws IOException {
        String path = request.getUri().getPath();
        if (path.startsWith("/tester/v1/run/")) {
            String type = TestRunnerHandler.lastElement(path);
            TestProfile testProfile = TestProfile.valueOf(type.toUpperCase() + "_TEST");
            byte[] config = IOUtils.readBytes((InputStream)request.getData(), (int)65536);
            this.testRunner.test(testProfile, config);
            this.log.info("Started tests of type " + type + " and status is " + this.testRunner.getStatus());
            return new Response("Successfully started " + type + " tests");
        }
        return new Response(404, "Not found: " + request.getUri().getPath());
    }

    private static String lastElement(String path) {
        int lastSlash;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((lastSlash = path.lastIndexOf("/")) < 0) {
            return path;
        }
        return path.substring(lastSlash + 1);
    }

    static Slime logToSlime(Collection<LogRecord> log) {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        Cursor recordArray = root.setArray("logRecords");
        TestRunnerHandler.logArrayToSlime(recordArray, log);
        return slime;
    }

    static void logArrayToSlime(Cursor recordArray, Collection<LogRecord> log) {
        log.forEach(record -> {
            Cursor recordObject = recordArray.addObject();
            recordObject.setLong("id", record.getSequenceNumber());
            recordObject.setLong("at", record.getMillis());
            recordObject.setString("type", TestRunnerHandler.typeOf(record.getLevel()));
            Object message = record.getMessage();
            if (record.getThrown() != null) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                record.getThrown().printStackTrace(new PrintStream(buffer));
                message = (String)message + "\n" + buffer;
            }
            recordObject.setString("message", (String)message);
        });
    }

    public static String typeOf(Level level) {
        return level.getName().equals("html") ? "html" : (level.intValue() < Level.INFO.intValue() ? "debug" : (level.intValue() < Level.WARNING.intValue() ? "info" : (level.intValue() < Level.SEVERE.intValue() ? "warning" : "error")));
    }

    private static class Response
    extends HttpResponse {
        private static final ObjectMapper objectMapper = new ObjectMapper();
        private final String message;

        private Response(String response) {
            this(200, response);
        }

        private Response(int statusCode, String message) {
            super(statusCode);
            this.message = message;
        }

        public void render(OutputStream outputStream) throws IOException {
            ObjectNode objectNode = objectMapper.createObjectNode();
            objectNode.put("message", this.message);
            objectMapper.writeValue(outputStream, (Object)objectNode);
        }

        public String getContentType() {
            return TestRunnerHandler.CONTENT_TYPE_APPLICATION_JSON;
        }
    }

    private static class SlimeJsonResponse
    extends HttpResponse {
        private final Slime slime;

        private SlimeJsonResponse(Slime slime) {
            super(200);
            this.slime = slime;
        }

        public void render(OutputStream outputStream) throws IOException {
            new JsonFormat(true).encode(outputStream, this.slime);
        }

        public String getContentType() {
            return TestRunnerHandler.CONTENT_TYPE_APPLICATION_JSON;
        }
    }
}

