/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.cloud;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Cluster {
    private final int size;
    private final List<Integer> indices;

    public Cluster(int size, List<Integer> indices) {
        Objects.requireNonNull(indices, "Indices cannot be null!");
        this.size = size;
        this.indices = Collections.unmodifiableList(indices);
    }

    public int size() {
        return this.size;
    }

    public List<Integer> indices() {
        return this.indices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)o;
        return this.size == cluster.size && this.indices.equals(cluster.indices);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.indices);
    }
}

