/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.cloud;

import ai.vespa.cloud.Environment;
import java.util.Objects;

public class Zone {
    private final Environment environment;
    private final String region;

    public Zone(Environment environment, String region) {
        this.environment = environment;
        this.region = region;
    }

    public Environment environment() {
        return this.environment;
    }

    public String region() {
        return this.region;
    }

    public String toString() {
        return this.environment + "." + this.region;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.environment, this.region});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Zone)) {
            return false;
        }
        Zone other = (Zone)o;
        return this.environment.equals((Object)other.environment) && this.region.equals(other.region);
    }

    public static Zone from(String zoneString) {
        Environment environment;
        String[] parts = zoneString.split("\\.");
        if (parts.length != 2) {
            throw new IllegalArgumentException("A zone string must be on the form [environment].[region], but was '" + zoneString + "'");
        }
        try {
            environment = Environment.valueOf(parts[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid zone '" + zoneString + "': No environment named '" + parts[0] + "'");
        }
        return new Zone(environment, parts[1]);
    }
}

