/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import ai.vespa.hosted.api.Method;
import ai.vespa.hosted.api.Signatures;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SignatureAlgorithm;
import com.yahoo.security.SignatureUtils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.time.Clock;
import java.util.Base64;
import java.util.function.Supplier;

public class RequestSigner {
    private final Signature signer;
    private final String keyId;
    private final String base64PemPublicKey;
    private final Clock clock;

    public RequestSigner(String pemPrivateKey, String keyId) {
        this(pemPrivateKey, keyId, Clock.systemUTC());
    }

    public RequestSigner(String pemPrivateKey, String keyId, Clock clock) {
        this(KeyUtils.fromPemEncodedPrivateKey((String)pemPrivateKey), keyId, clock);
    }

    public RequestSigner(PrivateKey privateKey, String keyId, Clock clock) {
        this.signer = SignatureUtils.createSigner((PrivateKey)privateKey, (SignatureAlgorithm)SignatureAlgorithm.SHA256_WITH_ECDSA);
        this.keyId = keyId;
        this.base64PemPublicKey = Base64.getEncoder().encodeToString(KeyUtils.toPem((PublicKey)KeyUtils.extractPublicKey((PrivateKey)privateKey)).getBytes(StandardCharsets.UTF_8));
        this.clock = clock;
    }

    public HttpRequest signed(HttpRequest.Builder request, Method method, Supplier<InputStream> data) {
        try {
            String timestamp = this.clock.instant().toString();
            String contentHash = Base64.getEncoder().encodeToString(Signatures.sha256Digest(data::get));
            byte[] canonicalMessage = Signatures.canonicalMessageOf(method.name(), request.copy().build().uri(), timestamp, contentHash);
            this.signer.update(canonicalMessage);
            String signature = Base64.getEncoder().encodeToString(this.signer.sign());
            request.setHeader("X-Timestamp", timestamp);
            request.setHeader("X-Content-Hash", contentHash);
            request.setHeader("X-Key-Id", this.keyId);
            request.setHeader("X-Key", this.base64PemPublicKey);
            request.setHeader("X-Authorization", signature);
            request.method(method.name(), HttpRequest.BodyPublishers.ofInputStream(data));
            return request.build();
        }
        catch (SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

