/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DeploymentLog {
    private final List<Entry> entries;
    private final boolean active;
    private final Status status;
    private final OptionalLong last;

    public DeploymentLog(List<Entry> entries, boolean active, Status status, OptionalLong last) {
        this.entries = entries.stream().sorted(Comparator.comparing(Entry::at)).collect(Collectors.toUnmodifiableList());
        this.active = active;
        this.status = status;
        this.last = last;
    }

    public DeploymentLog updatedWith(DeploymentLog other) {
        return new DeploymentLog(Stream.concat(this.entries.stream(), other.entries.stream()).collect(Collectors.toUnmodifiableList()), other.active, other.status, other.last);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public boolean isActive() {
        return this.active;
    }

    public Status status() {
        return this.status;
    }

    public OptionalLong last() {
        return this.last;
    }

    public String toString() {
        return "status: " + this.status.name() + ", " + (this.active ? "active" : "not active") + ", log entries:\n" + this.entries.stream().map(entry -> String.format("%s %s %s", new Object[]{entry.at(), entry.level(), entry.message()})).collect(Collectors.joining("\n"));
    }

    public static enum Status {
        running,
        aborted,
        error,
        testFailure,
        nodeAllocationFailure,
        installationFailed,
        deploymentFailed,
        endpointCertificateTimeout,
        success;

    }

    public static class Entry {
        private final Instant at;
        private final Level level;
        private final String message;
        private final boolean isVespaLogEntry;

        public Entry(Instant at, Level level, String message, boolean isVespaLogEntry) {
            this.at = at;
            this.level = level;
            this.message = message;
            this.isVespaLogEntry = isVespaLogEntry;
        }

        public Instant at() {
            return this.at;
        }

        public Level level() {
            return this.level;
        }

        public String message() {
            return this.message;
        }

        public boolean isVespaLogEntry() {
            return this.isVespaLogEntry;
        }
    }

    public static enum Level {
        error,
        warning,
        info,
        debug;


        public static Level of(String level) {
            switch (level) {
                case "error": {
                    return error;
                }
                case "warning": {
                    return warning;
                }
                case "info": {
                    return info;
                }
                case "debug": {
                    return debug;
                }
            }
            return debug;
        }
    }
}

