/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import java.nio.file.Path;
import java.util.Optional;

public class Deployment {
    private final Optional<String> version;
    private final Path applicationZip;

    private Deployment(Optional<String> version, Path applicationZip) {
        this.version = version;
        this.applicationZip = applicationZip;
    }

    public static Deployment ofPackage(Path applicationZipFile) {
        return new Deployment(Optional.empty(), applicationZipFile);
    }

    public Deployment atVersion(String vespaVersion) {
        return new Deployment(Optional.of(vespaVersion), this.applicationZip);
    }

    public Optional<String> version() {
        return this.version;
    }

    public Path applicationZip() {
        return this.applicationZip;
    }
}

