/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.hosted.api;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class Properties {
    public static ApplicationId application() {
        return ApplicationId.from((String)Properties.requireNonBlankProperty("tenant"), (String)Properties.requireNonBlankProperty("application"), (String)Properties.getNonBlankProperty("instance").orElse(Properties.user()));
    }

    public static Optional<Environment> environment() {
        return Properties.getNonBlankProperty("environment").map(Environment::from);
    }

    public static Optional<RegionName> region() {
        return Properties.getNonBlankProperty("region").map(RegionName::from);
    }

    public static URI apiEndpoint() {
        return URI.create(Properties.requireNonBlankProperty("endpoint"));
    }

    public static Path apiPrivateKeyFile() {
        return Paths.get(Properties.requireNonBlankProperty("privateKeyFile"), new String[0]);
    }

    public static Optional<Path> apiCertificateFile() {
        return Properties.getNonBlankProperty("certificateFile").map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static Optional<Path> dataPlaneCertificateFile() {
        return Properties.getNonBlankProperty("dataPlaneCertificateFile").map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static Optional<Path> dataPlanePrivateKeyFile() {
        return Properties.getNonBlankProperty("dataPlaneKeyFile").map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public static String user() {
        return System.getProperty("user.name");
    }

    public static Optional<String> getNonBlankProperty(String name) {
        return Optional.ofNullable(System.getProperty(name)).filter(value -> !value.isBlank());
    }

    public static String requireNonBlankProperty(String name) {
        return Properties.getNonBlankProperty(name).orElseThrow(() -> new IllegalStateException("Missing required property '" + name + "'"));
    }
}

