/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import com.yahoo.vespa.flags.custom.Sidecars;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundBooleanFlag USE_NON_PUBLIC_ENDPOINT_FOR_TEST = Flags.defineFeatureFlag("use-non-public-endpoint-for-test", false, List.of("hakonhall"), "2025-03-19", "2026-01-10", "Whether to use non-public endpoint in test and staging environments (except Azure since it's not supported yet)", "Takes effect on next deployment of the application", Dimension.INSTANCE_ID, Dimension.VESPA_VERSION);
    public static final UnboundBooleanFlag NEW_ADDRESS_ALLOCATION = Flags.defineFeatureFlag("new-address-allocation", false, List.of("hakonhall"), "2025-10-06", "2026-01-06", "Whether to use new address allocation during provisioning", "Takes effect on next host being provisioned", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag MULTI_IP = Flags.defineFeatureFlag("multi-ip", false, List.of("hakonhall"), "2025-10-10", "2026-01-10", "Whether to allow storing >1 IP address for any given IP version", "Takes effect on next host being provisioned", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag LOCKED_GCP_PROVISION = Flags.defineFeatureFlag("locked-gcp-provision", true, List.of("hakonhall"), "2025-08-05", "2026-01-15", "Whether to provision GCP hosts under the application- and unallocated- locks, even though it takes ~1m.", "Takes effect on next host being provisioned", new Dimension[0]);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("hmusum"), "2020-12-02", "2026-01-10", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("hmusum"), "2020-12-02", "2026-01-10", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", true, List.of("hmusum"), "2020-12-02", "2026-01-10", "Optionally deliver async messages in own thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_JAVA_NUM_TARGETS = Flags.defineIntFlag("mbus-java-num-targets", 2, List.of("hmusum"), "2022-07-05", "2026-01-10", "Number of rpc targets per service", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_CPP_NUM_TARGETS = Flags.defineIntFlag("mbus-cpp-num-targets", 2, List.of("hmusum"), "2022-07-05", "2026-01-10", "Number of rpc targets per service", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RPC_NUM_TARGETS = Flags.defineIntFlag("rpc-num-targets", 2, List.of("hmusum"), "2022-07-05", "2026-01-10", "Number of rpc targets per content node", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_JAVA_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-java-events-before-wakeup", 1, List.of("hmusum"), "2022-07-05", "2026-01-10", "Number of write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_CPP_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-cpp-events-before-wakeup", 1, List.of("hmusum"), "2022-07-05", "2026-01-10", "Number of write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RPC_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("rpc-events-before-wakeup", 1, List.of("hmusum"), "2022-07-05", "2026-01-10", "Number of write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_NUM_NETWORK_THREADS = Flags.defineIntFlag("mbus-num-network-threads", 1, List.of("hmusum"), "2022-07-01", "2026-01-10", "Number of threads used for mbus network", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS = Flags.defineIntFlag("max-activation-inhibited-out-of-sync-groups", 0, List.of("vekterli"), "2021-02-19", "2026-03-01", "Allows replicas in up to N content groups to not be activated for query visibility if they are out of sync with a majority of other replicas", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_V8_GEO_POSITIONS = Flags.defineFeatureFlag("use-v8-geo-positions", true, List.of("arnej"), "2021-11-15", "2025-12-01", "Use Vespa 8 types and formats for geographical positions", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag ENABLE_OTELCOL = Flags.defineFeatureFlag("enable-otel-collector", false, List.of("olaa"), "2022-09-23", "2026-02-01", "Whether an OpenTelemetry collector should be enabled", "Takes effect at next tick", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundListFlag<String> OTELCOL_LOGS = Flags.defineListFlag("otelcol-logs", List.of(), String.class, List.of("olaa"), "2024-01-15", "2026-02-01", "Determines log files handled by the OpenTelemetry collector", "Takes effect at next tick", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundStringFlag CORE_ENCRYPTION_PUBLIC_KEY_ID = Flags.defineStringFlag("core-encryption-public-key-id", "", List.of("vekterli"), "2022-11-03", "2026-05-01", "Specifies which public key to use for core dump encryption.", "Takes effect on the next tick.", Dimension.NODE_TYPE, Dimension.HOSTNAME);
    public static final UnboundListFlag<String> ZONAL_WEIGHTED_ENDPOINT_RECORDS = Flags.defineListFlag("zonal-weighted-endpoint-records", List.of(), String.class, List.of("hmusum"), "2023-12-15", "2026-01-10", "A list of weighted (application) endpoint fqdns for which we should use zonal endpoints as targets, not LBs.", "Takes effect at redeployment from controller", new Dimension[0]);
    public static final UnboundListFlag<String> WEIGHTED_ENDPOINT_RECORD_TTL = Flags.defineListFlag("weighted-endpoint-record-ttl", List.of(), String.class, List.of("hmusum"), "2023-05-16", "2026-01-10", "A list of endpoints and custom TTLs, on the form \"endpoint-fqdn:TTL-seconds\". Where specified, CNAME records are used instead of the default ALIAS records, which have a default 60s TTL.", "Takes effect at redeployment from controller", new Dimension[0]);
    public static final UnboundBooleanFlag WRITE_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB = Flags.defineFeatureFlag("write-config-server-session-data-as-blob", false, List.of("hmusum"), "2023-07-19", "2026-01-10", "Whether to write config server session data in one blob or as individual paths", "Takes effect immediately", new Dimension[0]);
    public static final UnboundBooleanFlag READ_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB = Flags.defineFeatureFlag("read-config-server-session-data-as-blob", false, List.of("hmusum"), "2023-07-19", "2026-01-10", "Whether to read config server session data from session data blob or from individual paths", "Takes effect immediately", new Dimension[0]);
    public static final UnboundBooleanFlag MORE_WIREGUARD = Flags.defineFeatureFlag("more-wireguard", false, List.of("andreer"), "2023-08-21", "2026-02-01", "Use wireguard in INternal enCLAVES", "Takes effect on next host-admin run", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundBooleanFlag IPV6_AWS_TARGET_GROUPS = Flags.defineFeatureFlag("ipv6-aws-target-groups", false, List.of("andreer"), "2023-08-28", "2026-02-01", "Always use IPv6 target groups for load balancers in aws", "Takes effect on next load-balancer provisioning", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundBooleanFlag PROVISION_IPV6_ONLY_AWS = Flags.defineFeatureFlag("provision-ipv6-only", false, List.of("andreer"), "2023-08-28", "2026-02-01", "Provision without private IPv4 addresses in INternal enCLAVES in AWS", "Takes effect on next host provisioning / run of host-admin", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundIntFlag CONTENT_LAYER_METADATA_FEATURE_LEVEL = Flags.defineIntFlag("content-layer-metadata-feature-level", 1, List.of("vekterli"), "2022-09-12", "2026-04-01", "Value semantics: 0) legacy behavior, 1) operation cancellation, 2) operation cancellation and ephemeral content node sequence numbers for bucket replicas", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag SEARCH_HANDLER_THREADPOOL = Flags.defineIntFlag("search-handler-threadpool", 10, List.of("bjorncs"), "2023-10-01", "2026-03-01", "Adjust search handler threadpool size", "Takes effect at redeployment", Dimension.APPLICATION);
    public static final UnboundDoubleFlag DOCPROC_HANDLER_THREADPOOL = Flags.defineDoubleFlag("docproc-handler-threadpool", 1.0, List.of("johsol"), "2025-10-17", "2026-01-01", "Adjust document processor handler threadpool size (scale the number of threads with cpu cores, 1 means same number of threads as cpu cores))", "Takes effect at redeployment", Dimension.APPLICATION);
    public static final UnboundStringFlag ENDPOINT_CONFIG = Flags.defineStringFlag("endpoint-config", "legacy", List.of("andreer", "olaa"), "2023-10-06", "2026-02-01", "Set the endpoint config to use for an application. Must be 'legacy', 'combined' or 'generated'. See EndpointConfig for further details", "Takes effect on next deployment through controller", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static UnboundBooleanFlag LOGSERVER_OTELCOL_AGENT = Flags.defineFeatureFlag("logserver-otelcol-agent", false, List.of("olaa"), "2024-04-03", "2026-02-01", "Whether logserver container should run otel agent", "Takes effect at redeployment", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_LEGACY_WAND_QUERY_PARSING = Flags.defineFeatureFlag("use-legacy-wand-query-parsing", true, List.of("arnej"), "2023-07-26", "2025-12-31", "If true, force legacy mode for weakAnd query parsing", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_SIMPLE_ANNOTATIONS = Flags.defineFeatureFlag("use-simple-annotations", false, List.of("arnej"), "2025-11-13", "2026-12-31", "Enable lightweight annotation representation for StringFieldValue", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag SEND_PROTOBUF_QUERYTREE = Flags.defineFeatureFlag("send-protobuf-querytree", false, List.of("arnej"), "2025-10-06", "2026-03-31", "If true, send query tree as protobuf in addition to legacy format", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag MONITORING_JWT = Flags.defineFeatureFlag("monitoring-jwt", false, List.of("olaa"), "2024-07-05", "2026-02-01", "Whether a monitoring JWT should be issued by the controller", "Takes effect immediately", Dimension.TENANT_ID, Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag SNAPSHOTS_ENABLED = Flags.defineFeatureFlag("snapshots-enabled", false, List.of("olaa"), "2024-10-22", "2026-02-01", "Whether node snapshots should be created when host storage is discarded", "Takes effect immediately", new Dimension[0]);
    public static final UnboundLongFlag ZOOKEEPER_PRE_ALLOC_SIZE_KIB = Flags.defineLongFlag("zookeeper-pre-alloc-size", 65536L, List.of("hmusum"), "2024-11-11", "2026-01-10", "Setting for zookeeper.preAllocSize flag in KiB, can be reduced from default value e.g. when running tests to avoid writing a large, sparse, mostly unused file", "Takes effect on restart of Docker container", new Dimension[0]);
    public static final UnboundBooleanFlag ENFORCE_EMAIL_DOMAIN_SSO = Flags.defineFeatureFlag("enforce-email-domain-sso", false, List.of("eirik"), "2024-11-07", "2026-02-01", "Enforce SSO login for an email domain", "Takes effect immediately", Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundListFlag<String> RESTRICT_USERS_TO_DOMAIN = Flags.defineListFlag("restrict-users-to-domain", List.of(), String.class, List.of("eirik"), "2024-11-07", "2026-02-01", "Only allow adding specific email domains as user to tenant", "Takes effect immediately", Dimension.TENANT_ID);
    public static final UnboundIntFlag DOCUMENT_V1_QUEUE_SIZE = Flags.defineIntFlag("document-v1-queue-size", -1, List.of("bjorncs"), "2025-01-14", "2026-03-01", "Size of the document v1 queue. Use -1 for default as determined by 'document-operation-executor.def'", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MAX_CONTENT_NODE_MAINTENANCE_OP_CONCURRENCY = Flags.defineIntFlag("max-content-node-maintenance-op-concurrency", -1, List.of("vekterli"), "2025-03-07", "2026-04-01", "Sets the maximum concurrency for maintenance-related operations on content nodes. Only intended as a manual emergency brake feature if a system is suddenly incapable of handling regular maintenance pressure.", "Takes effect immediately", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MAX_DOCUMENT_OPERATION_REQUEST_SIZE_MIB = Flags.defineIntFlag("max-document-operation-request-size-mib", 2048, List.of("glebashnik"), "2025-09-04", "2026-02-01", "Sets the maximum size in MiB of a document operation request (POST or PUT). This is the size of a serialized request, which can be several times larger than the content of the document, especially for tensors in JSON.POST and PUT requests larger than this will return HTTP 413 Content Too Large response and will not be added to the message bus queue.", "Takes effect immediately", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag DEFER_OS_UPGRADE = Flags.defineFeatureFlag("defer-os-upgrade", false, List.of("olaa"), "2025-04-09", "2026-02-01", "Whether OS upgrade should be deferred", "Takes effect immediately", Dimension.CLOUD_ACCOUNT);
    public static final UnboundJacksonFlag<Sidecars> SIDECARS_FOR_TEST = Flags.defineJacksonFlag("sidecars-for-test", Sidecars.DEFAULT, Sidecars.class, List.of("glebashnik"), "2025-04-25", "2025-12-01", "Specifies configuration for sidecars to testing provisioning", "Takes effect at redeployment", __ -> true, Dimension.APPLICATION);
    public static final UnboundBooleanFlag CREATE_TENANT_ROLES = Flags.defineFeatureFlag("create-tenant-roles", true, List.of("andreer"), "2025-04-28", "2026-02-01", "Whether to create tenant specific roles", "Takes effect immediately", Dimension.TENANT_ID);
    public static final UnboundBooleanFlag CONSOLE_DATA_PLANE_ACCESS = Flags.defineFeatureFlag("console-data-plane-access", false, List.of("laura"), "2025-08-15", "2025-12-01", "Temporary flag to enable console data plane access for testing purposes. Can be removed when full feature goes live", "Takes effect immediately", Dimension.TENANT_ID, Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag USE_TRITON = Flags.defineFeatureFlag("use-triton", false, List.of("bjorncs", "glebashnik"), "2025-04-30", "2026-06-01", "Whether to use Triton as ONNX runtime", "Takes effect at redeployment", new Dimension[0]);
    public static final UnboundBooleanFlag DELETE_TENANT_ROLES = Flags.defineFeatureFlag("delete-tenant-roles", false, List.of("andreer"), "2025-05-05", "2026-02-01", "Whether to delete tenant specific roles", "Role deletion happens when tenant is next processed by TenantRoleMaintainer", Dimension.TENANT_ID);
    public static final UnboundBooleanFlag AZURE_IPV6 = Flags.defineFeatureFlag("azure-ipv6", false, List.of("olaa"), "2025-06-10", "2026-02-01", "Whether Azure hosts should be provisioned with IPv6 addresses", "Takes effect immediately", new Dimension[0]);
    public static final UnboundBooleanFlag USE_NEW_PREPARE_FOR_RESTART_METHOD = Flags.defineFeatureFlag("use-new-prepare-for-restart-method", true, List.of("hmusum"), "2025-06-17", "2026-01-10", "Whether to use new logic and new RPC method to do prepareForRestart for content nodes", "Takes effect at next tick", Dimension.HOSTNAME);
    public static final UnboundIntFlag SEARCH_CORE_MAX_OUTSTANDING_MOVE_OPS = Flags.defineIntFlag("search-core-max-outstanding-move-ops", 100, List.of("hmusum"), "2025-07-09", "2026-01-10", "The max outstanding move operations a maintenance job can have before being blocked.", "Takes effect at next deployment of the application", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_VESPA_NODE_CTL = Flags.defineFeatureFlag("use-vespa-node-ctl", true, List.of("hmusum"), "2025-08-12", "2026-01-10", "Whether to use vespa-node-ctl to start, stop, restart, suspend and resume services or do this directly from host-admin.", "Takes effect at next tick", Dimension.HOSTNAME);
    public static final UnboundStringFlag VESPA_USE_MALLOC_IMPL = Flags.defineStringFlag("vespa-use-malloc-impl", "", List.of("hmusum", "johsol"), "2025-09-10", "2026-01-10", "Which malloc implementation to use  Valid values: 'vespamalloc', 'mimalloc', '' (empty string, meaning default malloc implementation).", "Takes effect at next reboot of the node", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID, Dimension.HOSTNAME, Dimension.CLUSTER_TYPE);
    public static final UnboundBooleanFlag ADJUST_JVM_HEAP_FOR_CC_BASED_ON_CONTENT_NODE_COUNT = Flags.defineFeatureFlag("adjust-jvm-heap-for-cc-based-on-content-node-count", true, List.of("hmusum"), "2025-11-04", "2026-02-04", "Whether to increase max JVM heap size based on total number of content nodes in application", "Takes effect at next restart after next deployment", Dimension.APPLICATION, Dimension.INSTANCE_ID);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.defineStringFlag(flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, (String value) -> true, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Predicate<String> validator, Dimension ... dimensions) {
        return Flags.define((i, d, v) -> new UnboundStringFlag(i, (String)d, v, validator), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Predicate<T> validator, Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass, validator), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Predicate<List<T>> validator, Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec, validator), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        if (flags.put(id, definition) != null) {
            throw new IllegalStateException("There are multiple definitions of the " + String.valueOf(id) + " flag");
        }
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting(FlagId ... flagsToKeep) {
        return new Replacer(flagsToKeep);
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer(FlagId ... flagsToKeep) {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
            List.of(flagsToKeep).forEach(id -> flags.put((FlagId)id, this.savedFlags.get(id)));
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }
}

