/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.NodeType;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.config.provision.Zone;
import com.yahoo.config.provision.zone.ZoneApi;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.FlagSerializer;
import java.util.Optional;

public interface Flag<T, F extends Flag<T, F>> {
    public FlagId id();

    public F self();

    public FlagSerializer<T> serializer();

    public F with(Dimension var1, String var2);

    default public F with(Dimension dimension, Optional<String> dimensionValue) {
        return (F)dimensionValue.map(value -> this.with(dimension, (String)value)).orElse((Flag)this.self());
    }

    default public F with(ApplicationId applicationId) {
        return this.with(Dimension.TENANT_ID, applicationId.tenant().value()).with(Dimension.APPLICATION, applicationId.toSerializedFormWithoutInstance()).with(Dimension.INSTANCE_ID, applicationId.serializedForm());
    }

    default public F with(NodeResources.Architecture architecture) {
        return this.with(Dimension.ARCHITECTURE, architecture.name());
    }

    default public F with(CloudAccount cloudAccount, Zone zone) {
        return cloudAccount.isEnclave(zone) ? this.with(Dimension.CLOUD_ACCOUNT, Optional.of(cloudAccount).map(CloudAccount::value)).with(Dimension.CLAVE, "enclave") : this.with(Dimension.CLAVE, "noclave");
    }

    default public F with(CloudName cloud) {
        return this.with(Dimension.CLOUD, cloud.value());
    }

    default public F with(ClusterSpec.Id clusterId) {
        return this.with(Dimension.CLUSTER_ID, clusterId.value());
    }

    default public F with(ClusterSpec.Type clusterType) {
        return this.with(Dimension.CLUSTER_TYPE, clusterType.name());
    }

    default public F with(Environment environment) {
        return this.with(Dimension.ENVIRONMENT, environment.value());
    }

    default public F with(NodeType nodeType) {
        return this.with(Dimension.NODE_TYPE, nodeType.name());
    }

    default public F with(SystemName systemName) {
        return this.with(Dimension.SYSTEM, systemName.value());
    }

    default public F with(TenantName tenantName) {
        return this.with(Dimension.TENANT_ID, tenantName.value());
    }

    default public F with(Version vespaVersion) {
        return this.with(Dimension.VESPA_VERSION, vespaVersion.toFullString());
    }

    default public F with(ZoneId zoneId) {
        return this.with(Dimension.ZONE_ID, zoneId.value()).with(Dimension.ENVIRONMENT, zoneId.environment().value());
    }

    default public F with(Zone zone) {
        return this.with(Dimension.ZONE_ID, zone.systemLocalValue()).with(Dimension.ENVIRONMENT, zone.environment().value());
    }

    default public F with(ZoneApi zoneApi) {
        return this.with(zoneApi.getVirtualId());
    }

    default public F withApplicationId(Optional<ApplicationId> applicationId) {
        return (F)applicationId.map(this::with).orElse((Flag)this.self());
    }

    default public F withArchitecture(Optional<NodeResources.Architecture> architecture) {
        return (F)architecture.map(this::with).orElse((Flag)this.self());
    }

    default public F withCloudAccount(Optional<CloudAccount> cloudAccount, Zone zone) {
        return (F)cloudAccount.map(account -> this.with((CloudAccount)account, zone)).orElse((Flag)this.self());
    }

    default public F withCloudName(Optional<CloudName> cloud) {
        return (F)cloud.map(this::with).orElse((Flag)this.self());
    }

    default public F withClusterId(Optional<ClusterSpec.Id> clusterId) {
        return (F)clusterId.map(this::with).orElse((Flag)this.self());
    }

    default public F withClusterType(Optional<ClusterSpec.Type> clusterType) {
        return (F)clusterType.map(this::with).orElse((Flag)this.self());
    }

    default public F withEnvironment(Optional<Environment> environment) {
        return (F)environment.map(this::with).orElse((Flag)this.self());
    }

    default public F withNodeType(Optional<NodeType> nodeType) {
        return (F)nodeType.map(this::with).orElse((Flag)this.self());
    }

    default public F withSystemName(Optional<SystemName> systemName) {
        return (F)systemName.map(this::with).orElse((Flag)this.self());
    }

    default public F withTenantName(Optional<TenantName> tenantName) {
        return (F)tenantName.map(this::with).orElse((Flag)this.self());
    }

    default public F withVersion(Optional<Version> vespaVersion) {
        return (F)vespaVersion.map(this::with).orElse((Flag)this.self());
    }

    default public F withZoneId(Optional<ZoneId> zoneId) {
        return (F)zoneId.map(this::with).orElse((Flag)this.self());
    }

    default public F withZone(Optional<Zone> zone) {
        return (F)zone.map(this::with).orElse((Flag)this.self());
    }

    default public F withZoneApi(Optional<ZoneApi> zoneApi) {
        return (F)zoneApi.map(this::with).orElse((Flag)this.self());
    }

    public T boxedValue();
}

