/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CustomerRpmService {
    @JsonProperty(value="unit", required=true)
    private final String unit;
    @JsonProperty(value="url", required=true)
    private final String url;
    @JsonProperty(value="memory", required=true)
    private final double memoryLimitMib;
    @JsonProperty(value="cpu")
    private final Double cpuLimitCores;

    @JsonCreator
    public CustomerRpmService(@JsonProperty(value="unit", required=true) String unit, @JsonProperty(value="url", required=true) String url, @JsonProperty(value="memory", required=true) double memoryLimitMib, @JsonProperty(value="cpu") Double cpuLimitCores) {
        this.unit = Objects.requireNonNull(unit);
        this.url = Objects.requireNonNull(url);
        this.memoryLimitMib = memoryLimitMib;
        this.cpuLimitCores = cpuLimitCores == null || cpuLimitCores <= 0.0 ? null : cpuLimitCores;
    }

    public String unitName() {
        return this.unit;
    }

    public String url() {
        return this.url;
    }

    public double memoryLimitMib() {
        return this.memoryLimitMib;
    }

    public Optional<Double> cpuLimitCores() {
        return Optional.ofNullable(this.cpuLimitCores);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerRpmService other = (CustomerRpmService)o;
        return this.unit.equals(other.unit) && this.url.equals(other.url) && this.memoryLimitMib == other.memoryLimitMib && this.cpuLimitCores().equals(other.cpuLimitCores());
    }

    public int hashCode() {
        return Objects.hash(this.unit, this.url, this.memoryLimitMib, this.cpuLimitCores);
    }
}

