/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.vespa.flags.custom.Validation;
import java.util.Objects;
import java.util.OptionalDouble;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClusterCapacity {
    private final int count;
    private final OptionalDouble vcpu;
    private final OptionalDouble memoryGb;
    private final OptionalDouble diskGb;
    private final OptionalDouble bandwidthGbps;
    private final String diskSpeed;
    private final String storageType;
    private final String architecture;
    private final String clusterType;

    @JsonCreator
    public ClusterCapacity(@JsonProperty(value="count") Integer count, @JsonProperty(value="vcpu") Double vcpu, @JsonProperty(value="memoryGb") Double memoryGb, @JsonProperty(value="diskGb") Double diskGb, @JsonProperty(value="bandwidthGbps") Double bandwidthGbps, @JsonProperty(value="diskSpeed") String diskSpeed, @JsonProperty(value="storageType") String storageType, @JsonProperty(value="architecture") String architecture, @JsonProperty(value="clusterType") String clusterType) {
        this.count = count == null ? 1 : (int)Validation.requireNonNegative("count", count.intValue());
        this.vcpu = vcpu == null ? OptionalDouble.empty() : OptionalDouble.of(Validation.requireNonNegative("vcpu", vcpu));
        this.memoryGb = memoryGb == null ? OptionalDouble.empty() : OptionalDouble.of(Validation.requireNonNegative("memoryGb", memoryGb));
        this.diskGb = diskGb == null ? OptionalDouble.empty() : OptionalDouble.of(Validation.requireNonNegative("diskGb", diskGb));
        this.bandwidthGbps = bandwidthGbps == null ? OptionalDouble.empty() : OptionalDouble.of(bandwidthGbps);
        this.diskSpeed = Validation.validateEnum("diskSpeed", Validation.validDiskSpeeds, diskSpeed == null ? "fast" : diskSpeed);
        this.storageType = Validation.validateEnum("storageType", Validation.validStorageTypes, storageType == null ? "any" : storageType);
        this.architecture = Validation.validateEnum("architecture", Validation.validArchitectures, architecture == null ? "x86_64" : architecture);
        this.clusterType = clusterType == null ? null : Validation.validateEnum("clusterType", Validation.validClusterTypes, clusterType);
    }

    public ClusterCapacity withCount(int count) {
        return new ClusterCapacity(count, this.vcpuOrNull(), this.memoryGbOrNull(), this.diskGbOrNull(), this.bandwidthGbpsOrNull(), this.diskSpeed, this.storageType, this.architecture, this.clusterType);
    }

    @JsonGetter(value="count")
    public int count() {
        return this.count;
    }

    @JsonGetter(value="vcpu")
    public Double vcpuOrNull() {
        return this.vcpu.isPresent() ? Double.valueOf(this.vcpu.getAsDouble()) : null;
    }

    @JsonGetter(value="memoryGb")
    public Double memoryGbOrNull() {
        return this.memoryGb.isPresent() ? Double.valueOf(this.memoryGb.getAsDouble()) : null;
    }

    @JsonGetter(value="diskGb")
    public Double diskGbOrNull() {
        return this.diskGb.isPresent() ? Double.valueOf(this.diskGb.getAsDouble()) : null;
    }

    @JsonGetter(value="bandwidthGbps")
    public Double bandwidthGbpsOrNull() {
        return this.bandwidthGbps.isPresent() ? Double.valueOf(this.bandwidthGbps.getAsDouble()) : null;
    }

    @JsonGetter(value="diskSpeed")
    public String diskSpeed() {
        return this.diskSpeed;
    }

    @JsonGetter(value="storageType")
    public String storageType() {
        return this.storageType;
    }

    @JsonGetter(value="architecture")
    public String architecture() {
        return this.architecture;
    }

    @JsonGetter(value="clusterType")
    public String clusterType() {
        return this.clusterType;
    }

    @JsonIgnore
    public Double vcpu() {
        return this.vcpu.orElse(0.0);
    }

    @JsonIgnore
    public Double memoryGb() {
        return this.memoryGb.orElse(0.0);
    }

    @JsonIgnore
    public Double diskGb() {
        return this.diskGb.orElse(0.0);
    }

    @JsonIgnore
    public double bandwidthGbps() {
        return this.bandwidthGbps.orElse(1.0);
    }

    public String toString() {
        return "ClusterCapacity{count=" + this.count + ", vcpu=" + this.vcpu + ", memoryGb=" + this.memoryGb + ", diskGb=" + this.diskGb + ", bandwidthGbps=" + this.bandwidthGbps + ", diskSpeed=" + this.diskSpeed + ", storageType=" + this.storageType + ", architecture=" + this.architecture + ", clusterType=" + this.clusterType + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterCapacity that = (ClusterCapacity)o;
        return this.count == that.count && this.vcpu.equals(that.vcpu) && this.memoryGb.equals(that.memoryGb) && this.diskGb.equals(that.diskGb) && this.bandwidthGbps.equals(that.bandwidthGbps) && this.diskSpeed.equals(that.diskSpeed) && this.storageType.equals(that.storageType) && this.architecture.equals(that.architecture) && this.clusterType.equals(that.clusterType);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture, this.clusterType);
    }
}

