/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.custom;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.SharedHosts;
import com.yahoo.vespa.flags.custom.HostResources;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SharedHost
implements SharedHosts {
    private final List<HostResources> resources;

    public static SharedHost createDisabled() {
        return new SharedHost(null);
    }

    @JsonCreator
    public SharedHost(@JsonProperty(value="resources") List<HostResources> resourcesOrNull) {
        this.resources = resourcesOrNull == null ? List.of() : List.copyOf(resourcesOrNull);
    }

    @JsonGetter(value="resources")
    public List<HostResources> getResourcesOrNull() {
        return this.resources.isEmpty() ? null : this.resources;
    }

    @JsonIgnore
    public boolean supportsClusterType(ClusterSpec.Type clusterType) {
        return this.resources.stream().anyMatch(resource -> resource.clusterType().map(type -> clusterType.name().equalsIgnoreCase((String)type)).orElse(true));
    }

    @JsonIgnore
    public boolean hasClusterType(ClusterSpec.Type clusterType) {
        return this.resources.stream().anyMatch(resource -> resource.clusterType().map(type -> clusterType.name().equalsIgnoreCase((String)type)).orElse(false));
    }

    @JsonIgnore
    public List<HostResources> getHostResources() {
        return this.resources;
    }

    public String toString() {
        return this.resources.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedHost that = (SharedHost)o;
        return this.resources.equals(that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.resources);
    }
}

