/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.fasterxml.jackson.databind.JavaType;
import com.yahoo.vespa.flags.FlagSerializer;
import com.yahoo.vespa.flags.JsonNodeRawFlag;
import com.yahoo.vespa.flags.RawFlag;
import java.util.List;
import java.util.function.Predicate;

public class JacksonArraySerializer<T>
implements FlagSerializer<List<T>> {
    private final JavaType type;
    private final Predicate<List<T>> validator;

    public JacksonArraySerializer(Class<T> clazz, Predicate<List<T>> validator) {
        this.type = JsonNodeRawFlag.constructCollectionType(List.class, clazz);
        this.validator = validator;
    }

    @Override
    public List<T> deserialize(RawFlag rawFlag) {
        List list = (List)JsonNodeRawFlag.fromJsonNode(rawFlag.asJsonNode()).toJacksonClass(this.type);
        if (!this.validator.test(list)) {
            throw new IllegalArgumentException("Invalid value: " + list);
        }
        return list;
    }

    @Override
    public RawFlag serialize(List<T> value) {
        return JsonNodeRawFlag.fromJacksonClass(value);
    }
}

