/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags;

import com.yahoo.component.Vtag;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.flags.Dimension;
import com.yahoo.vespa.flags.FetchVector;
import com.yahoo.vespa.flags.FlagDefinition;
import com.yahoo.vespa.flags.FlagId;
import com.yahoo.vespa.flags.UnboundBooleanFlag;
import com.yahoo.vespa.flags.UnboundDoubleFlag;
import com.yahoo.vespa.flags.UnboundFlag;
import com.yahoo.vespa.flags.UnboundIntFlag;
import com.yahoo.vespa.flags.UnboundJacksonFlag;
import com.yahoo.vespa.flags.UnboundListFlag;
import com.yahoo.vespa.flags.UnboundLongFlag;
import com.yahoo.vespa.flags.UnboundStringFlag;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public class Flags {
    private static volatile TreeMap<FlagId, FlagDefinition> flags = new TreeMap();
    public static final UnboundDoubleFlag DEFAULT_TERM_WISE_LIMIT = Flags.defineDoubleFlag("default-term-wise-limit", 1.0, List.of("baldersheim"), "2020-12-02", "2024-12-31", "Default limit for when to apply termwise query evaluation", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag QUERY_DISPATCH_POLICY = Flags.defineStringFlag("query-dispatch-policy", "adaptive", List.of("baldersheim"), "2022-08-20", "2024-12-31", "Select query dispatch policy, valid values are adaptive, round-robin, best-of-random-2, latency-amortized-over-requests, latency-amortized-over-time", "Takes effect at redeployment (requires restart)", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag SUMMARY_DECODE_POLICY = Flags.defineStringFlag("summary-decode-policy", "eager", List.of("baldersheim"), "2023-03-30", "2024-12-31", "Select summary decoding policy, valid values are eager and on-demand/ondemand.", "Takes effect at redeployment (requires restart)", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag FEED_SEQUENCER_TYPE = Flags.defineStringFlag("feed-sequencer-type", "THROUGHPUT", List.of("baldersheim"), "2020-12-02", "2024-12-31", "Selects type of sequenced executor used for feeding in proton, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment (requires restart)", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MAX_UNCOMMITTED_MEMORY = Flags.defineIntFlag("max-uncommitted-memory", 130000, List.of("geirst, baldersheim"), "2021-10-21", "2024-12-31", "Max amount of memory holding updates to an attribute before we do a commit.", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag RESPONSE_SEQUENCER_TYPE = Flags.defineStringFlag("response-sequencer-type", "ADAPTIVE", List.of("baldersheim"), "2020-12-02", "2024-12-31", "Selects type of sequenced executor used for mbus responses, valid values are LATENCY, ADAPTIVE, THROUGHPUT", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RESPONSE_NUM_THREADS = Flags.defineIntFlag("response-num-threads", 2, List.of("baldersheim"), "2020-12-02", "2024-12-31", "Number of threads used for mbus responses, default is 2, negative number = numcores/4", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag USE_ASYNC_MESSAGE_HANDLING_ON_SCHEDULE = Flags.defineFeatureFlag("async-message-handling-on-schedule", false, List.of("baldersheim"), "2020-12-02", "2024-12-31", "Optionally deliver async messages in own thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundDoubleFlag FEED_CONCURRENCY = Flags.defineDoubleFlag("feed-concurrency", 0.5, List.of("baldersheim"), "2020-12-02", "2024-12-31", "How much concurrency should be allowed for feed", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundDoubleFlag FEED_NICENESS = Flags.defineDoubleFlag("feed-niceness", 0.0, List.of("baldersheim"), "2022-06-24", "2024-12-31", "How nice feeding shall be", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_JAVA_NUM_TARGETS = Flags.defineIntFlag("mbus-java-num-targets", 2, List.of("baldersheim"), "2022-07-05", "2024-12-31", "Number of rpc targets per service", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_CPP_NUM_TARGETS = Flags.defineIntFlag("mbus-cpp-num-targets", 2, List.of("baldersheim"), "2022-07-05", "2024-12-31", "Number of rpc targets per service", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RPC_NUM_TARGETS = Flags.defineIntFlag("rpc-num-targets", 2, List.of("baldersheim"), "2022-07-05", "2024-12-31", "Number of rpc targets per content node", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_JAVA_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-java-events-before-wakeup", 1, List.of("baldersheim"), "2022-07-05", "2024-12-31", "Number write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_CPP_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("mbus-cpp-events-before-wakeup", 1, List.of("baldersheim"), "2022-07-05", "2024-12-31", "Number write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag RPC_EVENTS_BEFORE_WAKEUP = Flags.defineIntFlag("rpc-events-before-wakeup", 1, List.of("baldersheim"), "2022-07-05", "2024-12-31", "Number write events before waking up transport thread", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MBUS_NUM_NETWORK_THREADS = Flags.defineIntFlag("mbus-num-network-threads", 1, List.of("baldersheim"), "2022-07-01", "2024-12-31", "Number of threads used for mbus network", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag SHARED_STRING_REPO_NO_RECLAIM = Flags.defineFeatureFlag("shared-string-repo-no-reclaim", false, List.of("baldersheim"), "2022-06-14", "2024-12-31", "Controls whether we do track usage and reclaim unused enum values in shared string repo", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag CONTAINER_DUMP_HEAP_ON_SHUTDOWN_TIMEOUT = Flags.defineFeatureFlag("container-dump-heap-on-shutdown-timeout", false, List.of("baldersheim"), "2021-09-25", "2024-12-31", "Will trigger a heap dump during if container shutdown times out", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag LOAD_CODE_AS_HUGEPAGES = Flags.defineFeatureFlag("load-code-as-hugepages", false, List.of("baldersheim"), "2022-05-13", "2024-12-31", "Will try to map the code segment with huge (2M) pages", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundDoubleFlag CONTAINER_SHUTDOWN_TIMEOUT = Flags.defineDoubleFlag("container-shutdown-timeout", 50.0, List.of("baldersheim"), "2021-09-25", "2024-12-31", "Timeout for shutdown of a jdisc container", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundListFlag<String> ALLOWED_ATHENZ_PROXY_IDENTITIES = Flags.defineListFlag("allowed-athenz-proxy-identities", List.of(), String.class, List.of("bjorncs", "tokle"), "2021-02-10", "2024-04-01", "Allowed Athenz proxy identities", "takes effect at redeployment", new Dimension[0]);
    public static final UnboundIntFlag MAX_ACTIVATION_INHIBITED_OUT_OF_SYNC_GROUPS = Flags.defineIntFlag("max-activation-inhibited-out-of-sync-groups", 0, List.of("vekterli"), "2021-02-19", "2024-06-01", "Allows replicas in up to N content groups to not be activated for query visibility if they are out of sync with a majority of other replicas", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundDoubleFlag MIN_NODE_RATIO_PER_GROUP = Flags.defineDoubleFlag("min-node-ratio-per-group", 0.0, List.of("geirst", "vekterli"), "2021-07-16", "2024-06-01", "Minimum ratio of nodes that have to be available (i.e. not Down) in any hierarchic content cluster group for the group to be Up", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag SYSTEM_MEMORY_HIGH = Flags.defineStringFlag("system-memory-high", "", List.of("baldersheim"), "2023-02-14", "2024-12-31", "The value to write to /sys/fs/cgroup/system.slice/memory.high, if non-empty. You may want lower memory.high before lowering memory.max, and raise memory.high after raising memory.max.", "Takes effect on next tick.", Dimension.NODE_TYPE);
    public static final UnboundStringFlag SYSTEM_MEMORY_MAX = Flags.defineStringFlag("system-memory-max", "", List.of("baldersheim"), "2023-02-14", "2024-12-31", "The value to write to /sys/fs/cgroup/system.slice/memory.max, if non-empty. You may want lower memory.high before lowering memory.max, and raise memory.high after raising memory.max.", "Takes effect on next tick.", Dimension.NODE_TYPE);
    public static final UnboundBooleanFlag ENABLED_HORIZON_DASHBOARD = Flags.defineFeatureFlag("enabled-horizon-dashboard", false, List.of("olaa"), "2021-09-13", "2024-09-01", "Enable Horizon dashboard", "Takes effect immediately", Dimension.TENANT_ID, Dimension.CONSOLE_USER_EMAIL);
    public static final UnboundBooleanFlag USE_V8_GEO_POSITIONS = Flags.defineFeatureFlag("use-v8-geo-positions", true, List.of("arnej"), "2021-11-15", "2024-12-31", "Use Vespa 8 types and formats for geographical positions", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag MAX_COMPACT_BUFFERS = Flags.defineIntFlag("max-compact-buffers", 1, List.of("baldersheim", "geirst", "toregge"), "2021-12-15", "2024-12-31", "Upper limit of buffers to compact in a data store at the same time for each reason (memory usage, address space usage)", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag ENABLE_PROXY_PROTOCOL_MIXED_MODE = Flags.defineFeatureFlag("enable-proxy-protocol-mixed-mode", true, List.of("tokle"), "2022-05-09", "2024-04-01", "Enable or disable proxy protocol mixed mode", "Takes effect on redeployment", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag LOG_FILE_COMPRESSION_ALGORITHM = Flags.defineStringFlag("log-file-compression-algorithm", "", List.of("arnej"), "2022-06-14", "2024-12-31", "Which algorithm to use for compressing log files. Valid values: empty string (default), gzip, zstd", "Takes effect immediately", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag SEPARATE_METRIC_CHECK_CONFIG = Flags.defineFeatureFlag("separate-metric-check-config", false, List.of("olaa"), "2022-07-04", "2024-09-01", "Determines whether one metrics config check should be written per Vespa node", "Takes effect on next tick", Dimension.HOSTNAME);
    public static final UnboundStringFlag TLS_CAPABILITIES_ENFORCEMENT_MODE = Flags.defineStringFlag("tls-capabilities-enforcement-mode", "disable", List.of("bjorncs", "vekterli"), "2022-07-21", "2025-01-01", "Configure Vespa TLS capability enforcement mode", "Takes effect on restart of Docker container", Dimension.INSTANCE_ID, Dimension.HOSTNAME, Dimension.NODE_TYPE, Dimension.TENANT_ID, Dimension.VESPA_VERSION);
    public static final UnboundBooleanFlag ENABLE_OTELCOL = Flags.defineFeatureFlag("enable-otel-collector", false, List.of("olaa"), "2022-09-23", "2024-09-01", "Whether an OpenTelemetry collector should be enabled", "Takes effect at next tick", Dimension.INSTANCE_ID);
    public static final UnboundListFlag<String> OTELCOL_LOGS = Flags.defineListFlag("otelcol-logs", List.of(), String.class, List.of("olaa"), "2024-01-15", "2024-09-01", "Determines log files handled by the OpenTelemetry collector", "Takes effect at next tick", Dimension.INSTANCE_ID, Dimension.HOSTNAME);
    public static final UnboundStringFlag CORE_ENCRYPTION_PUBLIC_KEY_ID = Flags.defineStringFlag("core-encryption-public-key-id", "", List.of("vekterli"), "2022-11-03", "2024-06-01", "Specifies which public key to use for core dump encryption.", "Takes effect on the next tick.", Dimension.NODE_TYPE, Dimension.HOSTNAME);
    public static final UnboundListFlag<String> ZONAL_WEIGHTED_ENDPOINT_RECORDS = Flags.defineListFlag("zonal-weighted-endpoint-records", List.of(), String.class, List.of("jonmv"), "2023-12-15", "2024-06-01", "A list of weighted (application) endpoint fqdns for which we should use zonal endpoints as targets, not LBs.", "Takes effect at redeployment from controller", new Dimension[0]);
    public static final UnboundListFlag<String> WEIGHTED_ENDPOINT_RECORD_TTL = Flags.defineListFlag("weighted-endpoint-record-ttl", List.of(), String.class, List.of("jonmv"), "2023-05-16", "2024-06-01", "A list of endpoints and custom TTLs, on the form \"endpoint-fqdn:TTL-seconds\". Where specified, CNAME records are used instead of the default ALIAS records, which have a default 60s TTL.", "Takes effect at redeployment from controller", new Dimension[0]);
    public static final UnboundBooleanFlag SORT_BLUEPRINTS_BY_COST = Flags.defineFeatureFlag("sort-blueprints-by-cost", false, List.of("baldersheim"), "2023-12-19", "2024-05-31", "If true blueprints are sorted based on cost estimate, rather that absolute estimated hits", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag ALWAYS_MARK_PHRASE_EXPENSIVE = Flags.defineFeatureFlag("always-mark-phrase-expensive", false, List.of("baldersheim"), "2023-11-20", "2024-05-31", "If true all phrases will be marked expensive, independent of parents", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag WRITE_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB = Flags.defineFeatureFlag("write-config-server-session-data-as-blob", false, List.of("hmusum"), "2023-07-19", "2024-09-01", "Whether to write config server session data in one blob or as individual paths", "Takes effect immediately", new Dimension[0]);
    public static final UnboundBooleanFlag READ_CONFIG_SERVER_SESSION_DATA_AS_ONE_BLOB = Flags.defineFeatureFlag("read-config-server-session-data-as-blob", false, List.of("hmusum"), "2023-07-19", "2024-09-01", "Whether to read config server session data from session data blob or from individual paths", "Takes effect immediately", new Dimension[0]);
    public static final UnboundBooleanFlag MORE_WIREGUARD = Flags.defineFeatureFlag("more-wireguard", false, List.of("andreer"), "2023-08-21", "2024-03-24", "Use wireguard in INternal enCLAVES", "Takes effect on next host-admin run", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundBooleanFlag IPV6_AWS_TARGET_GROUPS = Flags.defineFeatureFlag("ipv6-aws-target-groups", false, List.of("andreer"), "2023-08-28", "2024-03-24", "Always use IPv6 target groups for load balancers in aws", "Takes effect on next load-balancer provisioning", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundBooleanFlag PROVISION_IPV6_ONLY_AWS = Flags.defineFeatureFlag("provision-ipv6-only", false, List.of("andreer"), "2023-08-28", "2024-03-24", "Provision without private IPv4 addresses in INternal enCLAVES in AWS", "Takes effect on next host provisioning / run of host-admin", Dimension.HOSTNAME, Dimension.CLOUD_ACCOUNT);
    public static final UnboundIntFlag CONTENT_LAYER_METADATA_FEATURE_LEVEL = Flags.defineIntFlag("content-layer-metadata-feature-level", 0, List.of("vekterli"), "2022-09-12", "2024-06-01", "Value semantics: 0) legacy behavior, 1) operation cancellation, 2) operation cancellation and ephemeral content node sequence numbers for bucket replicas", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag DYNAMIC_HEAP_SIZE = Flags.defineFeatureFlag("dynamic-heap-size", true, List.of("bjorncs"), "2023-09-21", "2024-04-15", "Whether to calculate JVM heap size based on predicted Onnx model memory requirements", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundStringFlag UNKNOWN_CONFIG_DEFINITION = Flags.defineStringFlag("unknown-config-definition", "warn", List.of("hmusum"), "2023-09-25", "2024-09-01", "How to handle user config referencing unknown config definitions. Valid values are 'warn' and 'fail'", "Takes effect at redeployment", Dimension.INSTANCE_ID);
    public static final UnboundIntFlag SEARCH_HANDLER_THREADPOOL = Flags.defineIntFlag("search-handler-threadpool", 2, List.of("bjorncs", "baldersheim"), "2023-10-01", "2025-01-01", "Adjust search handler threadpool size", "Takes effect at redeployment", Dimension.APPLICATION);
    public static final UnboundStringFlag ENDPOINT_CONFIG = Flags.defineStringFlag("endpoint-config", "legacy", List.of("mpolden", "tokle"), "2023-10-06", "2024-06-01", "Set the endpoint config to use for an application. Must be 'legacy', 'combined' or 'generated'. See EndpointConfig for further details", "Takes effect on next deployment through controller", Dimension.TENANT_ID, Dimension.APPLICATION, Dimension.INSTANCE_ID);
    public static final UnboundBooleanFlag CLOUD_TRIAL_NOTIFICATIONS = Flags.defineFeatureFlag("cloud-trial-notifications", false, List.of("bjorncs", "oyving"), "2023-10-13", "2024-12-31", "Whether to send cloud trial email notifications", "Takes effect immediately", new Dimension[0]);
    public static UnboundBooleanFlag CALYPSO_ENABLED = Flags.defineFeatureFlag("calypso-enabled", false, List.of("mortent"), "2024-02-19", "2024-05-01", "Whether to enable calypso for host", "Takes effect immediately", Dimension.HOSTNAME);

    public static UnboundBooleanFlag defineFeatureFlag(String flagId, boolean defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundBooleanFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.defineStringFlag(flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, (String value) -> true, dimensions);
    }

    public static UnboundStringFlag defineStringFlag(String flagId, String defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Predicate<String> validator, Dimension ... dimensions) {
        return Flags.define((i, d, v) -> new UnboundStringFlag(i, (String)d, v, validator), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundIntFlag defineIntFlag(String flagId, int defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundIntFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundLongFlag defineLongFlag(String flagId, long defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundLongFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static UnboundDoubleFlag defineDoubleFlag(String flagId, double defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define(UnboundDoubleFlag::new, flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundJacksonFlag<T> defineJacksonFlag(String flagId, T defaultValue, Class<T> jacksonClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define((id2, defaultValue2, vector2) -> new UnboundJacksonFlag<Object>(id2, defaultValue2, vector2, jacksonClass), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    public static <T> UnboundListFlag<T> defineListFlag(String flagId, List<T> defaultValue, Class<T> elementClass, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension ... dimensions) {
        return Flags.define((fid, dval, fvec) -> new UnboundListFlag(fid, dval, elementClass, fvec), flagId, defaultValue, owners, createdAt, expiresAt, description, modificationEffect, dimensions);
    }

    private static <T, U extends UnboundFlag<?, ?, ?>> U define(TypedUnboundFlagFactory<T, U> factory, String flagId, T defaultValue, List<String> owners, String createdAt, String expiresAt, String description, String modificationEffect, Dimension[] dimensions) {
        FlagId id = new FlagId(flagId);
        FetchVector vector = new FetchVector().with(Dimension.HOSTNAME, Defaults.getDefaults().vespaHostname()).with(Dimension.VESPA_VERSION, Vtag.currentVersion.toFullString());
        U unboundFlag = factory.create(id, defaultValue, vector);
        FlagDefinition definition = new FlagDefinition((UnboundFlag<?, ?, ?>)unboundFlag, owners, Flags.parseDate(createdAt), Flags.parseDate(expiresAt), description, modificationEffect, dimensions);
        flags.put(id, definition);
        return unboundFlag;
    }

    private static Instant parseDate(String rawDate) {
        return DateTimeFormatter.ISO_DATE.parse((CharSequence)rawDate, LocalDate::from).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    public static List<FlagDefinition> getAllFlags() {
        return List.copyOf(flags.values());
    }

    public static Optional<FlagDefinition> getFlag(FlagId flagId) {
        return Optional.ofNullable(flags.get(flagId));
    }

    public static Replacer clearFlagsForTesting(FlagId ... flagsToKeep) {
        return new Replacer(flagsToKeep);
    }

    @FunctionalInterface
    private static interface TypedUnboundFlagFactory<T, U extends UnboundFlag<?, ?, ?>> {
        public U create(FlagId var1, T var2, FetchVector var3);
    }

    public static class Replacer
    implements AutoCloseable {
        private static volatile boolean flagsCleared = false;
        private final TreeMap<FlagId, FlagDefinition> savedFlags;

        private Replacer(FlagId ... flagsToKeep) {
            Replacer.verifyAndSetFlagsCleared(true);
            this.savedFlags = flags;
            flags = new TreeMap();
            List.of(flagsToKeep).forEach(id -> flags.put((FlagId)id, this.savedFlags.get(id)));
        }

        @Override
        public void close() {
            Replacer.verifyAndSetFlagsCleared(false);
            flags = this.savedFlags;
        }

        private static void verifyAndSetFlagsCleared(boolean newValue) {
            if (flagsCleared == newValue) {
                throw new IllegalStateException("clearFlagsForTesting called while already cleared - running tests in parallell!?");
            }
            flagsCleared = newValue;
        }
    }
}

