/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.flags.json;

import java.util.Objects;
import java.util.function.Function;

public enum RelationalOperator {
    EQUAL("==", compareToValue -> compareToValue == 0),
    NOT_EQUAL("!=", compareToValue -> compareToValue != 0),
    LESS_EQUAL("<=", compareToValue -> compareToValue <= 0),
    LESS("<", compareToValue -> compareToValue < 0),
    GREATER_EQUAL(">=", compareToValue -> compareToValue >= 0),
    GREATER(">", compareToValue -> compareToValue > 0);

    private String text;
    private final Function<Integer, Boolean> compareToValuePredicate;

    private RelationalOperator(String text, Function<Integer, Boolean> compareToValuePredicate) {
        this.text = text;
        this.compareToValuePredicate = compareToValuePredicate;
    }

    public String toText() {
        return this.text;
    }

    public <T extends Comparable<T>> boolean evaluate(T left, T right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return this.evaluate(left.compareTo(right));
    }

    public boolean evaluate(int compareToValue) {
        return this.compareToValuePredicate.apply(compareToValue);
    }
}

